/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddDays;
import cdm.base.datetime.functions.IsBusinessDay;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=AddBusinessDaysDefault.class)
public abstract class AddBusinessDays
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected AddDays addDays;
    @Inject
    protected IsBusinessDay isBusinessDay;

    public Date evaluate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
        Date shiftedDate = this.doEvaluate(originalDate, offsetBusinessDays, businessCenters);
        return shiftedDate;
    }

    protected abstract Date doEvaluate(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Boolean> isGoodBusinessDay(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Integer> shift(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Date> shiftedByOne(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Boolean> isShiftedGood(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Integer> newShift(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Integer> newOffset(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Boolean> done(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Date> newDate(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    public static class AddBusinessDaysDefault
    extends AddBusinessDays {
        @Override
        protected Date doEvaluate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            Date shiftedDate = null;
            return this.assignOutput(shiftedDate, originalDate, offsetBusinessDays, businessCenters);
        }

        protected Date assignOutput(Date shiftedDate, Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            shiftedDate = (Date)MapperS.of((Object)((Date)this.newDate(originalDate, offsetBusinessDays, businessCenters).get())).get();
            return shiftedDate;
        }

        @Override
        protected Mapper<Boolean> isGoodBusinessDay(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate((Date)MapperS.of((Object)originalDate).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Integer> shift(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)-1);
                }
                return MapperS.of((Object)1);
            });
        }

        @Override
        protected Mapper<Date> shiftedByOne(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.addDays.evaluate((Date)MapperS.of((Object)originalDate).get(), (Integer)MapperS.of((Object)((Integer)this.shift(originalDate, offsetBusinessDays, businessCenters).get())).get()));
        }

        @Override
        protected Mapper<Boolean> isShiftedGood(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate((Date)MapperS.of((Object)((Date)this.shiftedByOne(originalDate, offsetBusinessDays, businessCenters).get())).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Integer> newShift(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperUtils.runSingle(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.isShiftedGood(originalDate, offsetBusinessDays, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)((Integer)this.shift(originalDate, offsetBusinessDays, businessCenters).get()));
                }
                return MapperS.of((Object)0);
            });
        }

        @Override
        protected Mapper<Integer> newOffset(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)0);
                }
                return MapperMaths.subtract((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)((Integer)this.newShift(originalDate, offsetBusinessDays, businessCenters).get())));
            });
        }

        @Override
        protected Mapper<Boolean> done(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.isGoodBusinessDay(originalDate, offsetBusinessDays, businessCenters).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All));
        }

        @Override
        protected Mapper<Date> newDate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperUtils.runSingle(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.done(originalDate, offsetBusinessDays, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)originalDate);
                }
                return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)((Date)this.shiftedByOne(originalDate, offsetBusinessDays, businessCenters).get())).get(), (Integer)MapperS.of((Object)((Integer)this.newOffset(originalDate, offsetBusinessDays, businessCenters).get())).get(), MapperC.of((List)businessCenters).getMulti()));
            });
        }
    }
}

