# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['AssetDeliveryInformation']


class AssetDeliveryInformation(BaseDataClass):
  """
  Contains the information relative to the delivery of the asset.
  """
  periods: Optional[AssetDeliveryPeriods] = Field(None, description="Defines the periods of delivery, including the delivery profile.")
  """
  Defines the periods of delivery, including the delivery profile.
  """
  location: List[LocationIdentifier] = Field([], description="Defines the location of the delivery of the commodity.")
  """
  Defines the location of the delivery of the commodity.
  """
  deliveryCapacity: Optional[Quantity] = Field(None, description="The number of units included in the transaction for each delivery interval")
  """
  The number of units included in the transaction for each delivery interval
  """

from cdm.product.asset.AssetDeliveryPeriods import AssetDeliveryPeriods
from cdm.base.staticdata.identifier.LocationIdentifier import LocationIdentifier
from cdm.base.math.Quantity import Quantity

AssetDeliveryInformation.update_forward_refs()
