# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['TransactionAdditionalTerms']


class TransactionAdditionalTerms(BaseDataClass):
  """
  Additional specification for the extraordinary events that may affect a trade and the related contractual rights and obligation of the parties when this happens. Such terms are typically required to extend the economics terms, for the purpose of producing the final legal contractual form of the Transaction.
  """
  equityAdditionalTerms: Optional[EquityAdditionalTerms] = Field(None, description="")
  foreignExchangeAdditionalTerms: Optional[FxAdditionalTerms] = Field(None, description="")
  commoditiesAdditionalTerms: Optional[str] = Field(None, description="")
  creditAdditionalTerms: Optional[str] = Field(None, description="")
  interestRateAdditionalTerms: Optional[str] = Field(None, description="")
  digitalAssetAdditionalTerms: Optional[str] = Field(None, description="")

from cdm.legaldocumentation.master.EquityAdditionalTerms import EquityAdditionalTerms
from cdm.legaldocumentation.master.FxAdditionalTerms import FxAdditionalTerms

TransactionAdditionalTerms.update_forward_refs()
