# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['ExtraordinaryEvents']


class ExtraordinaryEvents(BaseDataClass):
  """
  Where the underlying is shares, defines market events affecting the issuer of those shares that may require the terms of the transaction to be adjusted.
  """
  additionalBespokeTerms: List[Clause] = Field([], description="Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.")
  """
  Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.
  """
  mergerEvents: Optional[EquityCorporateEvents] = Field(None, description="Per the 2018 ISDA CDM Equity Confirmation for Security Equity Swap")
  """
  Per the 2018 ISDA CDM Equity Confirmation for Security Equity Swap
  """
  tenderOfferEvents: Optional[EquityCorporateEvents] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions: ")
  """
  Per the 2002 ISDA Equity Derivatives Definitions: 
  """
  compositionOfCombinedConsideration: Optional[bool] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions: ")
  """
  Per the 2002 ISDA Equity Derivatives Definitions: 
  """
  indexAdjustmentEvents: Optional[IndexAdjustmentEvents] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions: Adjustments to Indices ")
  """
  Per the 2002 ISDA Equity Derivatives Definitions: Adjustments to Indices 
  """
  additionalDisruptionEvents: Optional[AdditionalDisruptionEvents] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swaps")
  """
  Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swaps
  """
  failureToDeliver: Optional[bool] = Field(None, description="If true, failure to deliver is applicable.")
  """
  If true, failure to deliver is applicable.
  """
  representations: Optional[Representations] = Field(None, description="")
  nationalizationOrInsolvency: Optional[NationalizationOrInsolvencyOrDelistingEventEnum] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swap")
  """
  Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swap
  """
  delisting: Optional[NationalizationOrInsolvencyOrDelistingEventEnum] = Field(None, description="Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swap:")
  """
  Per the 2002 ISDA Equity Derivatives Definitions | 2018 ISDA CDM Equity Confirmation for Security Equity Swap:
  """
  
  @rosetta_condition
  def condition_0_ExtraordinaryEventsChoice(self):
    """
    condition to represent an FpML choice construct.
    """
    return self.check_one_of_constraint('additionalDisruptionEvents', 'failureToDeliver', necessity=True)

from cdm.legaldocumentation.master.Clause import Clause
from cdm.legaldocumentation.master.EquityCorporateEvents import EquityCorporateEvents
from cdm.legaldocumentation.master.IndexAdjustmentEvents import IndexAdjustmentEvents
from cdm.legaldocumentation.master.AdditionalDisruptionEvents import AdditionalDisruptionEvents
from cdm.legaldocumentation.master.Representations import Representations
from cdm.legaldocumentation.master.NationalizationOrInsolvencyOrDelistingEventEnum import NationalizationOrInsolvencyOrDelistingEventEnum

ExtraordinaryEvents.update_forward_refs()
