# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['InventoryRecord']


class InventoryRecord(BaseDataClass):
  """
  An individual piece of inventory. This represents a single security.
  """
  identifer: AssignedIdentifier = Field(..., description="Unique identifier for this record. This can be used to uniquely identify a specific piece of inventory.")
  """
  Unique identifier for this record. This can be used to uniquely identify a specific piece of inventory.
  """
  security: Security = Field(..., description="The security details.")
  """
  The security details.
  """

from cdm.base.staticdata.identifier.AssignedIdentifier import AssignedIdentifier
from cdm.base.staticdata.asset.common.Security import Security

InventoryRecord.update_forward_refs()
