from enum import Enum

all = ['InflationRateIndexEnum']
  
class InflationRateIndexEnum(Enum):
  """
  The enumerated values to specify the list of inflation rate indices.
  """
  AUD_CPI = "AUD-CPI"
  """
  Australia: AUD - Non-revised Consumer Price Index (CPI)
  """
  AUS_CPI = "AUS-CPI"
  """
  Austria: AUS - Non-revised Consumer Price Index (CPI)
  """
  AUS_HICP = "AUS-HICP"
  """
  Austria: AUS - Non-revised Harmonised Indices of Consumer Prices (HICP)
  """
  BLG_CPI_GI = "BLG-CPI-GI"
  """
  Belgium: BLG - Non-revised Consumer Price Index - General Index (CPI)
  """
  BLG_CPI_HI = "BLG-CPI-HI"
  """
  Belgium: BLG - Non-revised Consumer Price Index - Health Index (CPI)
  """
  BLG_HICP = "BLG-HICP"
  """
  Belgium: BLG - Non-revised Harmonised Consumer Price Index (HICP)
  """
  BRL_IGPM = "BRL-IGPM"
  """
  Brazil: BRL - Non-revised Price Index (IGP-M)
  """
  BRL_IPCA = "BRL-IPCA"
  """
  Brazil: BRL - Non-revised Consumer Price Index (IPCA)
  """
  CAD_CPI = "CAD-CPI"
  """
  Canada: CAD - Non-revised Consumer Price Index (CPI)
  """
  CLP_CPI = "CLP-CPI"
  """
  Chile: CLP - Non-revised Consumer Price Index (CPI)
  """
  CNY_CPI = "CNY-CPI"
  """
  China: CNY - Non-revised Consumer Price Index (CPI)
  """
  CZK_CPI = "CZK-CPI"
  """
  Czech Republic: CZK - Non-revised Consumer Price Index (CPI)
  """
  DEK_CPI = "DEK-CPI"
  """
  Denmark: DEK - Non-revised Consumer Price Index (CPI)
  """
  DEK_HICP = "DEK-HICP"
  """
  Denmark: DEK - Non-revised Harmonised Consumer Price Index (HICP)
  """
  DEM_CPI = "DEM-CPI"
  """
  Germany: DEM - Non-revised Consumer Price Index (CPI)
  """
  DEM_CPI_NRW = "DEM-CPI-NRW"
  """
  Germany: DEM - Non-revised Consumer Price Index for North Rhine-Westphalia
  """
  DEM_HICP = "DEM-HICP"
  """
  Germany: DEM - Non-revised Harmonised Consumer Price Index (HICP)
  """
  ESP_CPI = "ESP-CPI"
  """
  Spain: ESP - National-Non-revised Consumer Price Index (CPI)
  """
  ESP_HICP = "ESP-HICP"
  """
  Spain: ESP - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  ESP_R_CPI = "ESP-R-CPI"
  """
  Spain: ESP - National-Revised Consumer Price Index (CPI).
  """
  ESP_R_HICP = "ESP-R-HICP"
  """
  Spain: ESP - Harmonised-Revised Consumer Price Index (HICP)
  """
  EUR_AI_CPI = "EUR-AI-CPI"
  """
  European Union: EUR - All Items-Non-revised Consumer Price Index
  """
  EUR_AI_R_CPI = "EUR-AI-R-CPI"
  """
  European Union: EUR - All Items-Revised Consumer Price Index
  """
  EUR_EXT_CPI = "EUR-EXT-CPI"
  """
  European Union: EUR - Excluding Tobacco-Non-revised Consumer Price Index
  """
  EUR_EXT_R_CPI = "EUR-EXT-R-CPI"
  """
  European Union: EUR - Excluding Tobacco-Revised Consumer Price Index
  """
  FIN_CPI = "FIN-CPI"
  """
  Finland: FIN - Non-revised Consumer Price Index (CPI)
  """
  FIN_HICP = "FIN-HICP"
  """
  Finland: FIN - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  FRC_EXT_CPI = "FRC-EXT-CPI"
  """
  France: FRC - Excluding Tobacco-Non-Revised Consumer Price Index
  """
  FRC_HICP = "FRC-HICP"
  """
  France: FRC - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  GRD_CPI = "GRD-CPI"
  """
  Greece: GRD - Non-revised Consumer Price Index (CPI)
  """
  GRD_HICP = "GRD-HICP"
  """
  Greece: GRD - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  HKD_CPI = "HKD-CPI"
  """
  Hong Kong: HKD - Non-revised Consumer Price Index (CPI)
  """
  HUF_CPI = "HUF-CPI"
  """
  Hungary: HUF - Non-revised Consumer Price Index (CPI)
  """
  IDR_CPI = "IDR-CPI"
  """
  Indonesia: IDR - Non-revised Consumer Price Index (CPI)
  """
  ILS_CPI = "ILS-CPI"
  """
  Israel: ILS - Non-revised Consumer Price Index (CPI)
  """
  IRL_CPI = "IRL-CPI"
  """
  Ireland: IRL - Non-revised Consumer Price Index (CPI)
  """
  IRL_HICP = "IRL-HICP"
  """
  Ireland: IRL - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  ISK_CPI = "ISK-CPI"
  """
  Iceland: ISK - Non-revised Consumer Price Index (CPI)
  """
  ISK_HICP = "ISK-HICP"
  """
  Iceland: ISK - Harmonised Consumer Price Index (HICP)
  """
  ITL_BC_EXT_CPI = "ITL-BC-EXT-CPI"
  """
  Italy: ITL - Inflation for Blue Collar Workers and Employees-Excluding Tobacco Consumer Price Index
  """
  ITL_BC_INT_CPI = "ITL-BC-INT-CPI"
  """
  Italy: ITL - Inflation for Blue Collar Workers and Employees-Including Tobacco Consumer Price Index
  """
  ITL_HICP = "ITL-HICP"
  """
  Italy: ITL - Non-revised Harmonised Consumer Price Index (HICP)
  """
  ITL_WC_EXT_CPI = "ITL-WC-EXT-CPI"
  """
  Italy: ITL - Whole Community - Excluding Tobacco Consumer Price Index
  """
  ITL_WC_INT_CPI = "ITL-WC-INT-CPI"
  """
  Italy: ITL - Whole Community - Including Tobacco Consumer Price Index
  """
  JPY_CPI_EXF = "JPY-CPI-EXF"
  """
  Japan: JPY - Non-revised Consumer Price Index Nationwide General Excluding Fresh Food (CPI)
  """
  KRW_CPI = "KRW-CPI"
  """
  South Korea: KRW - Non-revised Consumer Price Index (CPI)
  """
  LUX_CPI = "LUX-CPI"
  """
  Luxembourg: LUX - Non-revised Consumer Price Index (CPI)
  """
  LUX_HICP = "LUX-HICP"
  """
  Luxembourg: LUX - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  MXN_CPI = "MXN-CPI"
  """
  Mexico: MXN - Non-revised Consumer Price Index (CPI)
  """
  MXN_UDI = "MXN-UDI"
  """
  Mexico: MXN - Unidad de Inversion Index (UDI)
  """
  MYR_CPI = "MYR-CPI"
  """
  Malaysia: MYR - Non-revised Consumer Price Index (CPI)
  """
  NLG_CPI = "NLG-CPI"
  """
  Netherlands: NLG - Non-revised Consumer Price Index (CPI)
  """
  NLG_HICP = "NLG-HICP"
  """
  Netherlands: NLG - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  NOK_CPI = "NOK-CPI"
  """
  Norway: NOK - Non-revised Consumer Price Index (CPI)
  """
  NZD_CPI = "NZD-CPI"
  """
  New Zealand: NZD - Non-revised Consumer Price Index (CPI)
  """
  PER_CPI = "PER-CPI"
  """
  Peru: PER - Non-revised Consumer Price Index (CPI)
  """
  PLN_CPI = "PLN-CPI"
  """
  Poland: PLN - Non-Revised Consumer Price Index (CPI)
  """
  POR_CPI = "POR-CPI"
  """
  Portugal: POR - Non-revised Consumer Price Index (CPI)
  """
  POR_HICP = "POR-HICP"
  """
  Portugal: POR - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  RUB_CPI = "RUB-CPI"
  """
  Russia: RUB - Non-revised Consumer Price Index (CPI)
  """
  SEK_CPI = "SEK-CPI"
  """
  Sweden: SEK - Non-revised Consumer Price Index (CPI)
  """
  SGD_CPI = "SGD-CPI"
  """
  Singapore: SGD - Non-revised Consumer Price Index (CPI)
  """
  SWF_CPI = "SWF-CPI"
  """
  Switzerland: SWF - Non-revised Consumer Price Index (CPI)
  """
  TRY_CPI = "TRY-CPI"
  """
  Turkey: TRY - Non-revised Consumer Price Index (CPI)
  """
  TWD_CPI = "TWD-CPI"
  """
  Taiwan: TWD - Non-revised Consumer Price Index (CPI)
  """
  UK_CPIH = "UK-CPIH"
  """
  United Kingdom: GBP - Non-revised Consumer Prices Index including Housing (UKCPIH)
  """
  UK_HICP = "UK-HICP"
  """
  United Kingdom: GBP - Harmonised-Non-revised Consumer Price Index (HICP)
  """
  UK_RPI = "UK-RPI"
  """
  United Kingdom: GBP - Non-revised Retail Price Index (UKRPI)
  """
  UK_RPIX = "UK-RPIX"
  """
  United Kingdom: GBP - Non-revised Retail Price Index Excluding Mortgage Interest Payments (UKRPIX)
  """
  USA_CPI_U = "USA-CPI-U"
  """
  United States: USA - Non-revised Consumer Price Index - Urban (CPI-U)
  """
  ZAR_CPI = "ZAR-CPI"
  """
  South Africa: ZAR - Non-revised Consumer Price Index (CPI)
  """
  ZAR_CPIX = "ZAR-CPIX"
  """
  South Africa: ZAR - Non-revised Consumer Price Index Excluding Mortgages (CPIX)
  """
