# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['AssetType']


class AssetType(BaseDataClass):
  """
  Represents a class to allow specification of the asset product type.
  """
  assetType: AssetTypeEnum = Field(..., description="Represents a filter based on the type of collateral asset.")
  """
  Represents a filter based on the type of collateral asset.
  """
  securityType: Optional[SecurityTypeEnum] = Field(None, description="Represents a filter based on the type of security.")
  """
  Represents a filter based on the type of security.
  """
  debtType: Optional[DebtType] = Field(None, description="Represents a filter based on the type of bond.")
  """
  Represents a filter based on the type of bond.
  """
  equityType: Optional[EquityTypeEnum] = Field(None, description="Represents a filter based on the type of equity.")
  """
  Represents a filter based on the type of equity.
  """
  fundType: Optional[FundProductTypeEnum] = Field(None, description="Represents a filter based on the type of fund.")
  """
  Represents a filter based on the type of fund.
  """
  otherAssetType: List[str] = Field([], description="Specifies the eligible asset type when not enumerated.")
  """
  Specifies the eligible asset type when not enumerated.
  """
  
  @rosetta_condition
  def condition_0_SecuritySubType(self):
    def _then_fn0():
      return (((((_resolve_rosetta_attr(self, "securityType")) is None) and ((_resolve_rosetta_attr(self, "debtType")) is None)) and ((_resolve_rosetta_attr(self, "equityType")) is None)) and ((_resolve_rosetta_attr(self, "fundType")) is None))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "assetType"), "<>", _resolve_rosetta_attr(AssetTypeEnum, "SECURITY")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_BondSubType(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "debtType")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "securityType"), "<>", _resolve_rosetta_attr(SecurityTypeEnum, "DEBT")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_EquitySubType(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "equityType")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "securityType"), "<>", _resolve_rosetta_attr(SecurityTypeEnum, "EQUITY")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_3_FundSubType(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "fundType")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "securityType"), "<>", _resolve_rosetta_attr(SecurityTypeEnum, "FUND")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_4_OtherAssetSubType(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "otherAssetType")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(all_elements(_resolve_rosetta_attr(self, "assetType"), "=", _resolve_rosetta_attr(AssetTypeEnum, "OTHER")), _then_fn0, _else_fn0)

from cdm.base.staticdata.asset.common.AssetTypeEnum import AssetTypeEnum
from cdm.base.staticdata.asset.common.SecurityTypeEnum import SecurityTypeEnum
from cdm.base.staticdata.asset.common.DebtType import DebtType
from cdm.base.staticdata.asset.common.EquityTypeEnum import EquityTypeEnum
from cdm.base.staticdata.asset.common.FundProductTypeEnum import FundProductTypeEnum

AssetType.update_forward_refs()
