package cdm.product.template.validation;

import cdm.product.template.CancelableProvision;
import cdm.product.template.EarlyTerminationProvision;
import cdm.product.template.EvergreenProvision;
import cdm.product.template.ExtendibleProvision;
import cdm.product.template.TerminationProvision;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class TerminationProvisionValidator implements Validator<TerminationProvision> {

	@Override
	public ValidationResult<TerminationProvision> validate(RosettaPath path, TerminationProvision o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("cancelableProvision", (CancelableProvision) o.getCancelableProvision() != null ? 1 : 0, 0, 1), 
				checkCardinality("earlyTerminationProvision", (EarlyTerminationProvision) o.getEarlyTerminationProvision() != null ? 1 : 0, 0, 1), 
				checkCardinality("evergreenProvision", (EvergreenProvision) o.getEvergreenProvision() != null ? 1 : 0, 0, 1), 
				checkCardinality("extendibleProvision", (ExtendibleProvision) o.getExtendibleProvision() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("TerminationProvision", ValidationType.CARDINALITY, "TerminationProvision", path, "", error);
		}
		return success("TerminationProvision", ValidationType.CARDINALITY, "TerminationProvision", path, "");
	}

}
