package cdm.product.template.validation;

import cdm.base.staticdata.party.PayerReceiverEnum;
import cdm.product.template.Strike;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class StrikeValidator implements Validator<Strike> {

	@Override
	public ValidationResult<Strike> validate(RosettaPath path, Strike o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("strikeRate", (BigDecimal) o.getStrikeRate() != null ? 1 : 0, 1, 1), 
				checkCardinality("buyer", (PayerReceiverEnum) o.getBuyer() != null ? 1 : 0, 0, 1), 
				checkCardinality("seller", (PayerReceiverEnum) o.getSeller() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Strike", ValidationType.CARDINALITY, "Strike", path, "", error);
		}
		return success("Strike", ValidationType.CARDINALITY, "Strike", path, "");
	}

}
