package cdm.product.template.validation;

import cdm.product.template.Basket;
import cdm.product.template.Product;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class BasketValidator implements Validator<Basket> {

	@Override
	public ValidationResult<Basket> validate(RosettaPath path, Basket o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("basketConstituent", (List<? extends Product>) o.getBasketConstituent() == null ? 0 : ((List<? extends Product>) o.getBasketConstituent()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Basket", ValidationType.CARDINALITY, "Basket", path, "", error);
		}
		return success("Basket", ValidationType.CARDINALITY, "Basket", path, "");
	}

}
