package cdm.product.common.settlement.validation;

import cdm.product.common.settlement.PaymentRule;
import cdm.product.common.settlement.PercentageRule;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class PaymentRuleValidator implements Validator<PaymentRule> {

	@Override
	public ValidationResult<PaymentRule> validate(RosettaPath path, PaymentRule o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("percentageRule", (PercentageRule) o.getPercentageRule() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("PaymentRule", ValidationType.CARDINALITY, "PaymentRule", path, "", error);
		}
		return success("PaymentRule", ValidationType.CARDINALITY, "PaymentRule", path, "");
	}

}
