package cdm.product.common.schedule.validation;

import cdm.product.common.schedule.FxLinkedNotionalSchedule;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FxLinkedNotionalScheduleTypeFormatValidator implements Validator<FxLinkedNotionalSchedule> {

	@Override
	public ValidationResult<FxLinkedNotionalSchedule> validate(RosettaPath path, FxLinkedNotionalSchedule o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FxLinkedNotionalSchedule", ValidationType.TYPE_FORMAT, "FxLinkedNotionalSchedule", path, "", error);
		}
		return success("FxLinkedNotionalSchedule", ValidationType.TYPE_FORMAT, "FxLinkedNotionalSchedule", path, "");
	}

}
