package cdm.product.common.schedule.validation;

import cdm.product.common.schedule.CalculationPeriod;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;

public class CalculationPeriodTypeFormatValidator implements Validator<CalculationPeriod> {

	@Override
	public ValidationResult<CalculationPeriod> validate(RosettaPath path, CalculationPeriod o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkNumber("calculationPeriodNumberOfDays", o.getCalculationPeriodNumberOfDays(), empty(), of(0), empty(), empty())
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CalculationPeriod", ValidationType.TYPE_FORMAT, "CalculationPeriod", path, "", error);
		}
		return success("CalculationPeriod", ValidationType.TYPE_FORMAT, "CalculationPeriod", path, "");
	}

}
