package cdm.product.collateral.validation;

import cdm.product.collateral.CollateralTreatment;
import cdm.product.collateral.CollateralValuationTreatment;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralTreatmentValidator implements Validator<CollateralTreatment> {

	@Override
	public ValidationResult<CollateralTreatment> validate(RosettaPath path, CollateralTreatment o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("valuationTreatment", (CollateralValuationTreatment) o.getValuationTreatment() != null ? 1 : 0, 0, 1), 
				checkCardinality("isIncluded", (Boolean) o.getIsIncluded() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralTreatment", ValidationType.CARDINALITY, "CollateralTreatment", path, "", error);
		}
		return success("CollateralTreatment", ValidationType.CARDINALITY, "CollateralTreatment", path, "");
	}

}
