package cdm.product.collateral.functions;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.AssetTypeEnum;
import cdm.base.staticdata.asset.common.DebtClassEnum;
import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CheckAssetType.CheckAssetTypeDefault.class)
public abstract class CheckAssetType implements RosettaFunction {

	/**
	* @param collateralAssetTypes 
	* @param query 
	* @return isEqual 
	*/
	public Boolean evaluate(List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
		Boolean isEqual = doEvaluate(collateralAssetTypes, query);
		
		return isEqual;
	}

	protected abstract Boolean doEvaluate(List<? extends AssetType> collateralAssetTypes, EligibilityQuery query);

	public static class CheckAssetTypeDefault extends CheckAssetType {
		@Override
		protected Boolean doEvaluate(List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
			Boolean isEqual = null;
			return assignOutput(isEqual, collateralAssetTypes, query);
		}
		
		protected Boolean assignOutput(Boolean isEqual, List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
			isEqual = notExists(MapperC.<AssetType>of(collateralAssetTypes)).or(ComparisonResult.of(MapperC.<AssetType>of(collateralAssetTypes)
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)contains(_item.<AssetTypeEnum>map("getAssetType", assetType -> assetType.getAssetType()), MapperS.of(query).<AssetType>map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).<AssetTypeEnum>map("getAssetType", assetType -> assetType.getAssetType())).get()))
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)notExists(_item.<DebtType>map("getDebtType", assetType -> assetType.getDebtType())).or(contains(_item.<DebtType>map("getDebtType", assetType -> assetType.getDebtType()).<DebtClassEnum>map("getDebtClass", debtType -> debtType.getDebtClass()), MapperS.of(query).<AssetType>map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).<DebtType>map("getDebtType", assetType -> assetType.getDebtType()).<DebtClassEnum>map("getDebtClass", debtType -> debtType.getDebtClass()))).get()))
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)notExists(_item.<SecurityTypeEnum>map("getSecurityType", assetType -> assetType.getSecurityType())).or(contains(_item.<SecurityTypeEnum>map("getSecurityType", assetType -> assetType.getSecurityType()), MapperS.of(query).<AssetType>map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).<SecurityTypeEnum>map("getSecurityType", assetType -> assetType.getSecurityType()))).get()))
				.apply(item -> exists(item).asMapper()))).get();
			
			return isEqual;
		}
	}
}
