package cdm.product.asset.validation;

import cdm.product.asset.VolatilityCapFloor;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class VolatilityCapFloorTypeFormatValidator implements Validator<VolatilityCapFloor> {

	@Override
	public ValidationResult<VolatilityCapFloor> validate(RosettaPath path, VolatilityCapFloor o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("VolatilityCapFloor", ValidationType.TYPE_FORMAT, "VolatilityCapFloor", path, "", error);
		}
		return success("VolatilityCapFloor", ValidationType.TYPE_FORMAT, "VolatilityCapFloor", path, "");
	}

}
