package cdm.product.asset.validation;

import cdm.product.asset.ReferencePool;
import cdm.product.asset.ReferencePoolItem;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ReferencePoolValidator implements Validator<ReferencePool> {

	@Override
	public ValidationResult<ReferencePool> validate(RosettaPath path, ReferencePool o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("referencePoolItem", (List<? extends ReferencePoolItem>) o.getReferencePoolItem() == null ? 0 : ((List<? extends ReferencePoolItem>) o.getReferencePoolItem()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ReferencePool", ValidationType.CARDINALITY, "ReferencePool", path, "", error);
		}
		return success("ReferencePool", ValidationType.CARDINALITY, "ReferencePool", path, "");
	}

}
