package cdm.product.asset.validation;

import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.Price;
import cdm.product.asset.ReferenceInformation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ReferenceInformationValidator implements Validator<ReferenceInformation> {

	@Override
	public ValidationResult<ReferenceInformation> validate(RosettaPath path, ReferenceInformation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("referenceEntity", (LegalEntity) o.getReferenceEntity() != null ? 1 : 0, 1, 1), 
				checkCardinality("noReferenceObligation", (Boolean) o.getNoReferenceObligation() != null ? 1 : 0, 0, 1), 
				checkCardinality("unknownReferenceObligation", (Boolean) o.getUnknownReferenceObligation() != null ? 1 : 0, 0, 1), 
				checkCardinality("allGuarantees", (Boolean) o.getAllGuarantees() != null ? 1 : 0, 0, 1), 
				checkCardinality("referencePrice", (Price) o.getReferencePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("referencePolicy", (Boolean) o.getReferencePolicy() != null ? 1 : 0, 0, 1), 
				checkCardinality("securedList", (Boolean) o.getSecuredList() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ReferenceInformation", ValidationType.CARDINALITY, "ReferenceInformation", path, "", error);
		}
		return success("ReferenceInformation", ValidationType.CARDINALITY, "ReferenceInformation", path, "");
	}

}
