package cdm.product.asset.validation;

import cdm.product.asset.InflationRateSpecification;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class InflationRateSpecificationTypeFormatValidator implements Validator<InflationRateSpecification> {

	@Override
	public ValidationResult<InflationRateSpecification> validate(RosettaPath path, InflationRateSpecification o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("InflationRateSpecification", ValidationType.TYPE_FORMAT, "InflationRateSpecification", path, "", error);
		}
		return success("InflationRateSpecification", ValidationType.TYPE_FORMAT, "InflationRateSpecification", path, "");
	}

}
