package cdm.product.asset.validation;

import cdm.product.asset.DividendPayoutRatio;
import cdm.product.template.Product;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class DividendPayoutRatioValidator implements Validator<DividendPayoutRatio> {

	@Override
	public ValidationResult<DividendPayoutRatio> validate(RosettaPath path, DividendPayoutRatio o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("totalRatio", (BigDecimal) o.getTotalRatio() != null ? 1 : 0, 1, 1), 
				checkCardinality("cashRatio", (BigDecimal) o.getCashRatio() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonCashRatio", (BigDecimal) o.getNonCashRatio() != null ? 1 : 0, 0, 1), 
				checkCardinality("basketConstituent", (Product) o.getBasketConstituent() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("DividendPayoutRatio", ValidationType.CARDINALITY, "DividendPayoutRatio", path, "", error);
		}
		return success("DividendPayoutRatio", ValidationType.CARDINALITY, "DividendPayoutRatio", path, "");
	}

}
