package cdm.product.asset.validation;

import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.product.asset.DiscountingMethod;
import cdm.product.asset.DiscountingTypeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class DiscountingMethodValidator implements Validator<DiscountingMethod> {

	@Override
	public ValidationResult<DiscountingMethod> validate(RosettaPath path, DiscountingMethod o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("discountingType", (DiscountingTypeEnum) o.getDiscountingType() != null ? 1 : 0, 1, 1), 
				checkCardinality("discountRate", (BigDecimal) o.getDiscountRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("discountRateDayCountFraction", (FieldWithMetaDayCountFractionEnum) o.getDiscountRateDayCountFraction() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("DiscountingMethod", ValidationType.CARDINALITY, "DiscountingMethod", path, "", error);
		}
		return success("DiscountingMethod", ValidationType.CARDINALITY, "DiscountingMethod", path, "");
	}

}
