package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.SingleValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("SingleValuationDateNonNegativeBusinessDays")
@ImplementedBy(SingleValuationDateNonNegativeBusinessDays.Default.class)
public interface SingleValuationDateNonNegativeBusinessDays extends Validator<SingleValuationDate> {
	
	String NAME = "SingleValuationDateNonNegativeBusinessDays";
	String DEFINITION = "if businessDays exists then businessDays >= 0";
	
	ValidationResult<SingleValuationDate> validate(RosettaPath path, SingleValuationDate singleValuationDate);
	
	class Default implements SingleValuationDateNonNegativeBusinessDays {
	
		@Override
		public ValidationResult<SingleValuationDate> validate(RosettaPath path, SingleValuationDate singleValuationDate) {
			ComparisonResult result = executeDataRule(singleValuationDate);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SingleValuationDate", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "SingleValuationDate", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(SingleValuationDate singleValuationDate) {
			try {
				ComparisonResult result = MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(singleValuationDate).<Integer>map("getBusinessDays", _singleValuationDate -> _singleValuationDate.getBusinessDays())).getOrDefault(false)) {
						return greaterThanEquals(MapperS.of(singleValuationDate).<Integer>map("getBusinessDays", _singleValuationDate -> _singleValuationDate.getBusinessDays()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All);
					}
					else {
						return null;
					}
				}));
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SingleValuationDateNonNegativeBusinessDays {
	
		@Override
		public ValidationResult<SingleValuationDate> validate(RosettaPath path, SingleValuationDate singleValuationDate) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SingleValuationDate", path, DEFINITION);
		}
	}
}
