package cdm.observable.asset.validation;

import cdm.base.staticdata.asset.common.Security;
import cdm.observable.asset.SecurityValuation;
import cdm.observable.asset.SecurityValuationModel;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class SecurityValuationValidator implements Validator<SecurityValuation> {

	@Override
	public ValidationResult<SecurityValuation> validate(RosettaPath path, SecurityValuation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("securityValuationModel", (SecurityValuationModel) o.getSecurityValuationModel() != null ? 1 : 0, 1, 1), 
				checkCardinality("underlier", (Security) o.getUnderlier() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("SecurityValuation", ValidationType.CARDINALITY, "SecurityValuation", path, "", error);
		}
		return success("SecurityValuation", ValidationType.CARDINALITY, "SecurityValuation", path, "");
	}

}
