package cdm.observable.asset.validation;

import cdm.observable.asset.CreditNotation;
import cdm.observable.asset.CreditRatingAgencyEnum;
import cdm.observable.asset.CreditRatingCreditWatchEnum;
import cdm.observable.asset.CreditRatingDebt;
import cdm.observable.asset.CreditRatingOutlookEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CreditNotationValidator implements Validator<CreditNotation> {

	@Override
	public ValidationResult<CreditNotation> validate(RosettaPath path, CreditNotation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("agency", (CreditRatingAgencyEnum) o.getAgency() != null ? 1 : 0, 1, 1), 
				checkCardinality("notation", (FieldWithMetaString) o.getNotation() != null ? 1 : 0, 1, 1), 
				checkCardinality("scale", (FieldWithMetaString) o.getScale() != null ? 1 : 0, 0, 1), 
				checkCardinality("debt", (CreditRatingDebt) o.getDebt() != null ? 1 : 0, 0, 1), 
				checkCardinality("outlook", (CreditRatingOutlookEnum) o.getOutlook() != null ? 1 : 0, 0, 1), 
				checkCardinality("creditWatch", (CreditRatingCreditWatchEnum) o.getCreditWatch() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CreditNotation", ValidationType.CARDINALITY, "CreditNotation", path, "", error);
		}
		return success("CreditNotation", ValidationType.CARDINALITY, "CreditNotation", path, "");
	}

}
