package cdm.observable.asset.validation;

import cdm.observable.asset.CleanPrice;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CleanPriceValidator implements Validator<CleanPrice> {

	@Override
	public ValidationResult<CleanPrice> validate(RosettaPath path, CleanPrice o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("cleanPrice", (BigDecimal) o.getCleanPrice() != null ? 1 : 0, 1, 1), 
				checkCardinality("accruals", (BigDecimal) o.getAccruals() != null ? 1 : 0, 0, 1), 
				checkCardinality("dirtyPrice", (String) o.getDirtyPrice() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CleanPrice", ValidationType.CARDINALITY, "CleanPrice", path, "", error);
		}
		return success("CleanPrice", ValidationType.CARDINALITY, "CleanPrice", path, "");
	}

}
