package cdm.legaldocumentation.master.validation;

import cdm.legaldocumentation.master.MasterAgreementVariableSet;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MasterAgreementVariableSetValidator implements Validator<MasterAgreementVariableSet> {

	@Override
	public ValidationResult<MasterAgreementVariableSet> validate(RosettaPath path, MasterAgreementVariableSet o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("name", (String) o.getName() != null ? 1 : 0, 0, 1), 
				checkCardinality("value", (String) o.getValue() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MasterAgreementVariableSet", ValidationType.CARDINALITY, "MasterAgreementVariableSet", path, "", error);
		}
		return success("MasterAgreementVariableSet", ValidationType.CARDINALITY, "MasterAgreementVariableSet", path, "");
	}

}
