package cdm.event.workflow.validation;

import cdm.event.workflow.CreditLimitUtilisation;
import cdm.event.workflow.CreditLimitUtilisationPosition;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CreditLimitUtilisationValidator implements Validator<CreditLimitUtilisation> {

	@Override
	public ValidationResult<CreditLimitUtilisation> validate(RosettaPath path, CreditLimitUtilisation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("executed", (CreditLimitUtilisationPosition) o.getExecuted() != null ? 1 : 0, 0, 1), 
				checkCardinality("pending", (CreditLimitUtilisationPosition) o.getPending() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CreditLimitUtilisation", ValidationType.CARDINALITY, "CreditLimitUtilisation", path, "", error);
		}
		return success("CreditLimitUtilisation", ValidationType.CARDINALITY, "CreditLimitUtilisation", path, "");
	}

}
