package cdm.event.qualification.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByCurrencyExists;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_StockSplit.Qualify_StockSplitDefault.class)
public abstract class Qualify_StockSplit implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FilterQuantityByCurrencyExists filterQuantityByCurrencyExists;
	@Inject protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> beforeTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> afterTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<? extends NonNegativeQuantitySchedule> beforeQuantities(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforeNoOfUnits(BusinessEvent businessEvent);

	protected abstract Mapper<? extends NonNegativeQuantitySchedule> afterQuantities(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterNoOfUnits(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforeCurrencyAmount(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterCurrencyAmount(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforePrice(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterPrice(BusinessEvent businessEvent);

	protected abstract Mapper<Boolean> currencyAmountUnchanged(BusinessEvent businessEvent);

	protected abstract Mapper<Boolean> noOfUnitsChanged(BusinessEvent businessEvent);

	protected abstract Mapper<Boolean> cashPriceChanged(BusinessEvent businessEvent);

	protected abstract Mapper<Boolean> adjustmentRatioMatches(BusinessEvent businessEvent);

	public static class Qualify_StockSplitDefault extends Qualify_StockSplit {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = areEqual(MapperS.of(currencyAmountUnchanged(businessEvent).get()), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All).and(areEqual(MapperS.of(noOfUnitsChanged(businessEvent).get()), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All)).and(areEqual(MapperS.of(cashPriceChanged(businessEvent).get()), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All)).and(areEqual(MapperS.of(adjustmentRatioMatches(businessEvent).get()), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends TradeState> beforeTradeState(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("getValue", _f->_f.getValue()).get());
		}
		
		@Override
		protected Mapper<? extends TradeState> afterTradeState(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).get());
		}
		
		@Override
		protected Mapper<? extends NonNegativeQuantitySchedule> beforeQuantities(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(beforeTradeState(businessEvent).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue());
		}
		
		@Override
		protected Mapper<BigDecimal> beforeNoOfUnits(BusinessEvent businessEvent) {
			return MapperS.of(MapperC.<QuantitySchedule>of(filterQuantityByFinancialUnit.evaluate(MapperC.<NonNegativeQuantitySchedule>of(beforeQuantities(businessEvent).getMulti()).getMulti(), MapperS.of(FinancialUnitEnum.SHARE).get())).get()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue());
		}
		
		@Override
		protected Mapper<? extends NonNegativeQuantitySchedule> afterQuantities(BusinessEvent businessEvent) {
			return MapperS.of(afterTradeState(businessEvent).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue());
		}
		
		@Override
		protected Mapper<BigDecimal> afterNoOfUnits(BusinessEvent businessEvent) {
			return MapperS.of(MapperC.<QuantitySchedule>of(filterQuantityByFinancialUnit.evaluate(MapperC.<NonNegativeQuantitySchedule>of(afterQuantities(businessEvent).getMulti()).getMulti(), MapperS.of(FinancialUnitEnum.SHARE).get())).get()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue());
		}
		
		@Override
		protected Mapper<BigDecimal> beforeCurrencyAmount(BusinessEvent businessEvent) {
			return MapperS.of(distinct(MapperC.<QuantitySchedule>of(filterQuantityByCurrencyExists.evaluate(MapperC.<NonNegativeQuantitySchedule>of(beforeQuantities(businessEvent).getMulti()).getMulti())).<BigDecimal>map("getValue", measureBase -> measureBase.getValue())).get());
		}
		
		@Override
		protected Mapper<BigDecimal> afterCurrencyAmount(BusinessEvent businessEvent) {
			return MapperS.of(distinct(MapperC.<QuantitySchedule>of(filterQuantityByCurrencyExists.evaluate(MapperC.<NonNegativeQuantitySchedule>of(afterQuantities(businessEvent).getMulti()).getMulti())).<BigDecimal>map("getValue", measureBase -> measureBase.getValue())).get());
		}
		
		@Override
		protected Mapper<BigDecimal> beforePrice(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(beforeTradeState(businessEvent).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue())
				.filterItemNullSafe(item -> (Boolean)areEqual(item.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), MapperS.of(FinancialUnitEnum.SHARE), CardinalityOperator.All).get())
				.apply(item -> item
					.mapItem(_item -> (MapperS<BigDecimal>)_item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue())))
				.apply(item -> MapperS.of(item.get()));
		}
		
		@Override
		protected Mapper<BigDecimal> afterPrice(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(afterTradeState(businessEvent).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue())
				.filterItemNullSafe(item -> (Boolean)areEqual(item.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), MapperS.of(FinancialUnitEnum.SHARE), CardinalityOperator.All).get())
				.apply(item -> item
					.mapItem(_item -> (MapperS<BigDecimal>)_item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue())))
				.apply(item -> MapperS.of(item.get()));
		}
		
		@Override
		protected Mapper<Boolean> currencyAmountUnchanged(BusinessEvent businessEvent) {
			return MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(beforeCurrencyAmount(businessEvent).get())).and(exists(MapperS.of(afterCurrencyAmount(businessEvent).get()))).getOrDefault(false)) {
					return areEqual(MapperS.of(beforeCurrencyAmount(businessEvent).get()), MapperS.of(afterCurrencyAmount(businessEvent).get()), CardinalityOperator.All);
				}
				else {
					return MapperS.of(Boolean.valueOf(false));
				}
			}));
		}
		
		@Override
		protected Mapper<Boolean> noOfUnitsChanged(BusinessEvent businessEvent) {
			return MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(beforeNoOfUnits(businessEvent).get())).and(exists(MapperS.of(afterNoOfUnits(businessEvent).get()))).getOrDefault(false)) {
					return notEqual(MapperS.of(afterNoOfUnits(businessEvent).get()), MapperS.of(beforeNoOfUnits(businessEvent).get()), CardinalityOperator.Any);
				}
				else {
					return MapperS.of(Boolean.valueOf(false));
				}
			}));
		}
		
		@Override
		protected Mapper<Boolean> cashPriceChanged(BusinessEvent businessEvent) {
			return MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(beforePrice(businessEvent).get())).and(exists(MapperS.of(afterPrice(businessEvent).get()))).getOrDefault(false)) {
					return notEqual(MapperS.of(beforePrice(businessEvent).get()), MapperS.of(afterPrice(businessEvent).get()), CardinalityOperator.Any);
				}
				else {
					return MapperS.of(Boolean.valueOf(false));
				}
			}));
		}
		
		@Override
		protected Mapper<Boolean> adjustmentRatioMatches(BusinessEvent businessEvent) {
			return MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(beforeNoOfUnits(businessEvent).get())).and(greaterThan(MapperS.of(beforeNoOfUnits(businessEvent).get()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All)).and(exists(MapperS.of(afterNoOfUnits(businessEvent).get()))).and(exists(MapperS.of(beforePrice(businessEvent).get()))).and(exists(MapperS.of(afterPrice(businessEvent).get()))).and(greaterThan(MapperS.of(afterPrice(businessEvent).get()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All)).getOrDefault(false)) {
					return areEqual(MapperMaths.<BigDecimal, BigDecimal, BigDecimal>divide(MapperS.of(afterNoOfUnits(businessEvent).get()), MapperS.of(beforeNoOfUnits(businessEvent).get())), MapperMaths.<BigDecimal, BigDecimal, BigDecimal>divide(MapperS.of(beforePrice(businessEvent).get()), MapperS.of(afterPrice(businessEvent).get())), CardinalityOperator.All);
				}
				else {
					return MapperS.of(Boolean.valueOf(false));
				}
			}));
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
