package cdm.event.common.validation;

import cdm.event.common.MarginCallBase;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MarginCallBaseTypeFormatValidator implements Validator<MarginCallBase> {

	@Override
	public ValidationResult<MarginCallBase> validate(RosettaPath path, MarginCallBase o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MarginCallBase", ValidationType.TYPE_FORMAT, "MarginCallBase", path, "", error);
		}
		return success("MarginCallBase", ValidationType.TYPE_FORMAT, "MarginCallBase", path, "");
	}

}
