package cdm.event.common.validation;

import cdm.event.common.ExerciseEvent;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ExerciseEventValidator implements Validator<ExerciseEvent> {

	@Override
	public ValidationResult<ExerciseEvent> validate(RosettaPath path, ExerciseEvent o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("adjustedExerciseDate", (Date) o.getAdjustedExerciseDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("adjustedRelevantSwapEffectiveDate", (Date) o.getAdjustedRelevantSwapEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("adjustedCashSettlementValuationDate", (Date) o.getAdjustedCashSettlementValuationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("adjustedCashSettlementPaymentDate", (Date) o.getAdjustedCashSettlementPaymentDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("adjustedExerciseFeePaymentDate", (Date) o.getAdjustedExerciseFeePaymentDate() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ExerciseEvent", ValidationType.CARDINALITY, "ExerciseEvent", path, "", error);
		}
		return success("ExerciseEvent", ValidationType.CARDINALITY, "ExerciseEvent", path, "");
	}

}
