package cdm.event.common.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.StockSplitInstruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.TradeState.TradeStateBuilder;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_StockSplit.Create_StockSplitDefault.class)
public abstract class Create_StockSplit implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_TradeState create_TradeState;
	@Inject protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

	/**
	* @param stockSplitInstruction 
	* @param before 
	* @return after 
	*/
	public TradeState evaluate(StockSplitInstruction stockSplitInstruction, TradeState before) {
		TradeState.TradeStateBuilder afterBuilder = doEvaluate(stockSplitInstruction, before);
		
		final TradeState after;
		if (afterBuilder == null) {
			after = null;
		} else {
			after = afterBuilder.build();
			objectValidator.validate(TradeState.class, after);
		}
		
		return after;
	}

	protected abstract TradeState.TradeStateBuilder doEvaluate(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<BigDecimal> preSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends NonNegativeQuantitySchedule> postSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends PriceSchedule> preSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends Price> postSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends PriceQuantity> postSplitPriceQuantity(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends QuantityChangeInstruction> quantityChangeInstruction(StockSplitInstruction stockSplitInstruction, TradeState before);

	protected abstract Mapper<? extends PrimitiveInstruction> primitiveInstruction(StockSplitInstruction stockSplitInstruction, TradeState before);

	public static class Create_StockSplitDefault extends Create_StockSplit {
		@Override
		protected TradeState.TradeStateBuilder doEvaluate(StockSplitInstruction stockSplitInstruction, TradeState before) {
			TradeState.TradeStateBuilder after = TradeState.builder();
			return assignOutput(after, stockSplitInstruction, before);
		}
		
		protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder after, StockSplitInstruction stockSplitInstruction, TradeState before) {
			after = toBuilder(MapperS.of(create_TradeState.evaluate(MapperS.of(primitiveInstruction(stockSplitInstruction, before).get()).get(), MapperS.of(before).get())).get());
			
			return Optional.ofNullable(after)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected Mapper<BigDecimal> preSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(MapperC.<QuantitySchedule>of(filterQuantityByFinancialUnit.evaluate(MapperS.of(MapperS.of(before).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue()).getMulti(), MapperS.of(FinancialUnitEnum.SHARE).get())).get()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue());
		}
		
		@Override
		protected Mapper<? extends NonNegativeQuantitySchedule> postSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(NonNegativeQuantitySchedule.builder()
				.setValue(MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(MapperS.of(preSplitNumberOfShares(stockSplitInstruction, before).get()), MapperS.of(stockSplitInstruction).<BigDecimal>map("getAdjustmentRatio", _stockSplitInstruction -> _stockSplitInstruction.getAdjustmentRatio())).get())
				.setUnit(MapperS.of(UnitType.builder()
					.setFinancialUnit(MapperS.of(FinancialUnitEnum.SHARE).get())
					.build())
				.get())
				.build())
			;
		}
		
		@Override
		protected Mapper<? extends PriceSchedule> preSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(before).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue())
				.filterItemNullSafe(item -> (Boolean)areEqual(item.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), MapperS.of(FinancialUnitEnum.SHARE), CardinalityOperator.All).get())
				.apply(item -> MapperS.of(item.get()));
		}
		
		@Override
		protected Mapper<? extends Price> postSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(Price.builder()
				.setValue(MapperMaths.<BigDecimal, BigDecimal, BigDecimal>divide(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue()), MapperS.of(stockSplitInstruction).<BigDecimal>map("getAdjustmentRatio", _stockSplitInstruction -> _stockSplitInstruction.getAdjustmentRatio())).get())
				.setUnit(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<UnitType>map("getUnit", measureBase -> measureBase.getUnit()).get())
				.setPerUnitOf(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get())
				.setPriceType(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get())
				.setPriceExpression(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<PriceExpressionEnum>map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get())
				.setComposite(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<PriceComposite>map("getComposite", priceSchedule -> priceSchedule.getComposite()).get())
				.setArithmeticOperator(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()).get())
				.setCashPrice(MapperS.of(preSplitPrice(stockSplitInstruction, before).get()).<CashPrice>map("getCashPrice", priceSchedule -> priceSchedule.getCashPrice()).get())
				.setDatedValue(MapperC.<DatedValue>ofNull().getMulti())
				.build())
			;
		}
		
		@Override
		protected Mapper<? extends PriceQuantity> postSplitPriceQuantity(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(PriceQuantity.builder()
				.setPriceValue(MapperS.of(postSplitPrice(stockSplitInstruction, before).get()).getMulti())
				.setQuantityValue(MapperS.of(postSplitNumberOfShares(stockSplitInstruction, before).get()).getMulti())
				.build())
			;
		}
		
		@Override
		protected Mapper<? extends QuantityChangeInstruction> quantityChangeInstruction(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(QuantityChangeInstruction.builder()
				.setChange(MapperS.of(postSplitPriceQuantity(stockSplitInstruction, before).get()).getMulti())
				.setDirection(MapperS.of(QuantityChangeDirectionEnum.REPLACE).get())
				.setLotIdentifier(MapperC.<Identifier>ofNull().getMulti())
				.build())
			;
		}
		
		@Override
		protected Mapper<? extends PrimitiveInstruction> primitiveInstruction(StockSplitInstruction stockSplitInstruction, TradeState before) {
			return MapperS.of(PrimitiveInstruction.builder()
				.setQuantityChange(MapperS.of(quantityChangeInstruction(stockSplitInstruction, before).get()).get())
				.build())
			;
		}
	}
}
