package cdm.base.staticdata.party.metafields;

import cdm.base.staticdata.party.NaturalPerson;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.ReferenceWithMeta.ReferenceWithMetaBuilder;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1
 */
@RosettaDataType(value="ReferenceWithMetaNaturalPerson", builder=ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilderImpl.class, version="0.0.0")
public interface ReferenceWithMetaNaturalPerson extends RosettaModelObject, ReferenceWithMeta<NaturalPerson> {

	ReferenceWithMetaNaturalPersonMeta metaData = new ReferenceWithMetaNaturalPersonMeta();

	/*********************** Getter Methods  ***********************/
	NaturalPerson getValue();
	String getGlobalReference();
	String getExternalReference();
	Reference getReference();

	/*********************** Build Methods  ***********************/
	ReferenceWithMetaNaturalPerson build();
	
	ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder toBuilder();
	
	static ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder builder() {
		return new ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ReferenceWithMetaNaturalPerson> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends ReferenceWithMetaNaturalPerson> getType() {
		return ReferenceWithMetaNaturalPerson.class;
	}
	
	@Override
	default Class<NaturalPerson> getValueType() {
		return NaturalPerson.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
		processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
		
		processRosetta(path.newSubPath("value"), processor, NaturalPerson.class, getValue());
		processRosetta(path.newSubPath("reference"), processor, Reference.class, getReference());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ReferenceWithMetaNaturalPersonBuilder extends ReferenceWithMetaNaturalPerson, RosettaModelObjectBuilder, ReferenceWithMeta.ReferenceWithMetaBuilder<NaturalPerson> {
		NaturalPerson.NaturalPersonBuilder getOrCreateValue();
		NaturalPerson.NaturalPersonBuilder getValue();
		Reference.ReferenceBuilder getOrCreateReference();
		Reference.ReferenceBuilder getReference();
		ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setValue(NaturalPerson value);
		ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setGlobalReference(String globalReference);
		ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setExternalReference(String externalReference);
		ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setReference(Reference reference);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			
			processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
			processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
			
			processRosetta(path.newSubPath("value"), processor, NaturalPerson.NaturalPersonBuilder.class, getValue());
			processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, getReference());
		}
		

		ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder prune();
	}

	/*********************** Immutable Implementation of ReferenceWithMetaNaturalPerson  ***********************/
	class ReferenceWithMetaNaturalPersonImpl implements ReferenceWithMetaNaturalPerson {
		private final NaturalPerson value;
		private final String globalReference;
		private final String externalReference;
		private final Reference reference;
		
		protected ReferenceWithMetaNaturalPersonImpl(ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder builder) {
			this.value = ofNullable(builder.getValue()).map(f->f.build()).orElse(null);
			this.globalReference = builder.getGlobalReference();
			this.externalReference = builder.getExternalReference();
			this.reference = ofNullable(builder.getReference()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("value")
		public NaturalPerson getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("globalReference")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		public Reference getReference() {
			return reference;
		}
		
		@Override
		public ReferenceWithMetaNaturalPerson build() {
			return this;
		}
		
		@Override
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder toBuilder() {
			ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
			ofNullable(getGlobalReference()).ifPresent(builder::setGlobalReference);
			ofNullable(getExternalReference()).ifPresent(builder::setExternalReference);
			ofNullable(getReference()).ifPresent(builder::setReference);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaNaturalPerson _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaNaturalPerson {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}

	/*********************** Builder Implementation of ReferenceWithMetaNaturalPerson  ***********************/
	class ReferenceWithMetaNaturalPersonBuilderImpl implements ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder {
	
		protected NaturalPerson.NaturalPersonBuilder value;
		protected String globalReference;
		protected String externalReference;
		protected Reference.ReferenceBuilder reference;
	
		public ReferenceWithMetaNaturalPersonBuilderImpl() {
		}
	
		@Override
		@RosettaAttribute("value")
		public NaturalPerson.NaturalPersonBuilder getValue() {
			return value;
		}
		
		@Override
		public NaturalPerson.NaturalPersonBuilder getOrCreateValue() {
			NaturalPerson.NaturalPersonBuilder result;
			if (value!=null) {
				result = value;
			}
			else {
				result = value = NaturalPerson.builder();
			}
			
			return result;
		}
		@Override
		@RosettaAttribute("globalReference")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		public Reference.ReferenceBuilder getReference() {
			return reference;
		}
		
		@Override
		public Reference.ReferenceBuilder getOrCreateReference() {
			Reference.ReferenceBuilder result;
			if (reference!=null) {
				result = reference;
			}
			else {
				result = reference = Reference.builder();
			}
			
			return result;
		}
	
		@Override
		@RosettaAttribute("value")
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setValue(NaturalPerson value) {
			this.value = value==null?null:value.toBuilder();
			return this;
		}
		@Override
		@RosettaAttribute("globalReference")
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setGlobalReference(String globalReference) {
			this.globalReference = globalReference==null?null:globalReference;
			return this;
		}
		@Override
		@RosettaAttribute("externalReference")
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setExternalReference(String externalReference) {
			this.externalReference = externalReference==null?null:externalReference;
			return this;
		}
		@Override
		@RosettaAttribute("address")
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder setReference(Reference reference) {
			this.reference = reference==null?null:reference.toBuilder();
			return this;
		}
		
		@Override
		public ReferenceWithMetaNaturalPerson build() {
			return new ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonImpl(this);
		}
		
		@Override
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder prune() {
			if (value!=null && !value.prune().hasData()) value = null;
			if (reference!=null && !reference.prune().hasData()) reference = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null && getValue().hasData()) return true;
			if (getGlobalReference()!=null) return true;
			if (getExternalReference()!=null) return true;
			if (getReference()!=null && getReference().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder o = (ReferenceWithMetaNaturalPerson.ReferenceWithMetaNaturalPersonBuilder) other;
			
			merger.mergeRosetta(getValue(), o.getValue(), this::setValue);
			merger.mergeRosetta(getReference(), o.getReference(), this::setReference);
			
			merger.mergeBasic(getGlobalReference(), o.getGlobalReference(), this::setGlobalReference);
			merger.mergeBasic(getExternalReference(), o.getExternalReference(), this::setExternalReference);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaNaturalPerson _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaNaturalPersonBuilder {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}
}

class ReferenceWithMetaNaturalPersonMeta extends BasicRosettaMetaData<ReferenceWithMetaNaturalPerson>{

}
