package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.QuasiGovernmentIssuerType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("QuasiGovernmentIssuerTypeNonSovereignEntityRecourse")
@ImplementedBy(QuasiGovernmentIssuerTypeNonSovereignEntityRecourse.Default.class)
public interface QuasiGovernmentIssuerTypeNonSovereignEntityRecourse extends Validator<QuasiGovernmentIssuerType> {
	
	String NAME = "QuasiGovernmentIssuerTypeNonSovereignEntityRecourse";
	String DEFINITION = "if sovereignRecourse exists then sovereignEntity = False";
	
	ValidationResult<QuasiGovernmentIssuerType> validate(RosettaPath path, QuasiGovernmentIssuerType quasiGovernmentIssuerType);
	
	class Default implements QuasiGovernmentIssuerTypeNonSovereignEntityRecourse {
	
		@Override
		public ValidationResult<QuasiGovernmentIssuerType> validate(RosettaPath path, QuasiGovernmentIssuerType quasiGovernmentIssuerType) {
			ComparisonResult result = executeDataRule(quasiGovernmentIssuerType);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "QuasiGovernmentIssuerType", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "QuasiGovernmentIssuerType", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(QuasiGovernmentIssuerType quasiGovernmentIssuerType) {
			try {
				ComparisonResult result = MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(quasiGovernmentIssuerType).<Boolean>map("getSovereignRecourse", _quasiGovernmentIssuerType -> _quasiGovernmentIssuerType.getSovereignRecourse())).getOrDefault(false)) {
						return areEqual(MapperS.of(quasiGovernmentIssuerType).<Boolean>map("getSovereignEntity", _quasiGovernmentIssuerType -> _quasiGovernmentIssuerType.getSovereignEntity()), MapperS.of(Boolean.valueOf(false)), CardinalityOperator.All);
					}
					else {
						return null;
					}
				}));
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements QuasiGovernmentIssuerTypeNonSovereignEntityRecourse {
	
		@Override
		public ValidationResult<QuasiGovernmentIssuerType> validate(RosettaPath path, QuasiGovernmentIssuerType quasiGovernmentIssuerType) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "QuasiGovernmentIssuerType", path, DEFINITION);
		}
	}
}
