package cdm.base.math.validation;

import cdm.base.math.NumberBound;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class NumberBoundTypeFormatValidator implements Validator<NumberBound> {

	@Override
	public ValidationResult<NumberBound> validate(RosettaPath path, NumberBound o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("NumberBound", ValidationType.TYPE_FORMAT, "NumberBound", path, "", error);
		}
		return success("NumberBound", ValidationType.TYPE_FORMAT, "NumberBound", path, "");
	}

}
