package cdm.base.datetime.validation;

import cdm.base.datetime.CustomisableOffset;
import cdm.base.datetime.Offset;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CustomisableOffsetValidator implements Validator<CustomisableOffset> {

	@Override
	public ValidationResult<CustomisableOffset> validate(RosettaPath path, CustomisableOffset o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("offset", (Offset) o.getOffset() != null ? 1 : 0, 0, 1), 
				checkCardinality("customProvision", (String) o.getCustomProvision() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CustomisableOffset", ValidationType.CARDINALITY, "CustomisableOffset", path, "", error);
		}
		return success("CustomisableOffset", ValidationType.CARDINALITY, "CustomisableOffset", path, "");
	}

}
