package cdm.base.datetime.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.PeriodEnum;
import cdm.base.datetime.RelativeDateOffset;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.ReferenceWithMetaDate;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ConvertToAdjustableOrRelativeDate.ConvertToAdjustableOrRelativeDateDefault.class)
public abstract class ConvertToAdjustableOrRelativeDate implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param adjustableOrAdjustedOrRelativeDate 
	* @return adjustableOrRelativeDate 
	*/
	public AdjustableOrRelativeDate evaluate(AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate) {
		AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder adjustableOrRelativeDateBuilder = doEvaluate(adjustableOrAdjustedOrRelativeDate);
		
		final AdjustableOrRelativeDate adjustableOrRelativeDate;
		if (adjustableOrRelativeDateBuilder == null) {
			adjustableOrRelativeDate = null;
		} else {
			adjustableOrRelativeDate = adjustableOrRelativeDateBuilder.build();
			objectValidator.validate(AdjustableOrRelativeDate.class, adjustableOrRelativeDate);
		}
		
		return adjustableOrRelativeDate;
	}

	protected abstract AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder doEvaluate(AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate);

	protected abstract Mapper<? extends RelativeDateOffset> relativeDate(AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate);

	public static class ConvertToAdjustableOrRelativeDateDefault extends ConvertToAdjustableOrRelativeDate {
		@Override
		protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder doEvaluate(AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate) {
			AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder adjustableOrRelativeDate = AdjustableOrRelativeDate.builder();
			return assignOutput(adjustableOrRelativeDate, adjustableOrAdjustedOrRelativeDate);
		}
		
		protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder assignOutput(AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder adjustableOrRelativeDate, AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate) {
			adjustableOrRelativeDate
				.getOrCreateAdjustableDate()
				.setAdjustedDateValue(MapperS.of(adjustableOrAdjustedOrRelativeDate).<FieldWithMetaDate>map("getAdjustedDate", _adjustableOrAdjustedOrRelativeDate -> _adjustableOrAdjustedOrRelativeDate.getAdjustedDate()).<Date>map("getValue", _f->_f.getValue()).get());
			
			adjustableOrRelativeDate
				.getOrCreateAdjustableDate()
				.setUnadjustedDate(MapperS.of(adjustableOrAdjustedOrRelativeDate).<Date>map("getUnadjustedDate", _adjustableOrAdjustedOrRelativeDate -> _adjustableOrAdjustedOrRelativeDate.getUnadjustedDate()).get());
			
			adjustableOrRelativeDate
				.getOrCreateAdjustableDate()
				.setDateAdjustments(MapperS.of(adjustableOrAdjustedOrRelativeDate).<BusinessDayAdjustments>map("getDateAdjustments", _adjustableOrAdjustedOrRelativeDate -> _adjustableOrAdjustedOrRelativeDate.getDateAdjustments()).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setAdjustedDate(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<Date>map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setBusinessCenters(MapperUtils.runSinglePolymorphic(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<BusinessCenters>map("getBusinessCenters", relativeDateOffset -> relativeDateOffset.getBusinessCenters());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setBusinessDayConvention(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<BusinessDayConventionEnum>map("getBusinessDayConvention", relativeDateOffset -> relativeDateOffset.getBusinessDayConvention());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setDateRelativeToValue(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<ReferenceWithMetaDate>map("getDateRelativeTo", relativeDateOffset -> relativeDateOffset.getDateRelativeTo()).<Date>map("getValue", _f->_f.getValue());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setDayType(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<DayTypeEnum>map("getDayType", offset -> offset.getDayType());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setPeriod(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<PeriodEnum>map("getPeriod", period -> period.getPeriod());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrRelativeDate
				.getOrCreateRelativeDate()
				.setPeriodMultiplier(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrAdjustedOrRelativeDate).get()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
					}
					else {
						return null;
					}
				}).get());
			
			return Optional.ofNullable(adjustableOrRelativeDate)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected Mapper<? extends RelativeDateOffset> relativeDate(AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate) {
			return MapperS.of(adjustableOrAdjustedOrRelativeDate).<RelativeDateOffset>map("getRelativeDate", _adjustableOrAdjustedOrRelativeDate -> _adjustableOrAdjustedOrRelativeDate.getRelativeDate());
		}
	}
}
