/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;

public class XmlConfiguration
implements Configuration {
    public static final URL CORE_SCHEMA_URL = Objects.requireNonNull(XmlConfiguration.class.getResource("/ehcache-core.xsd"));
    private final URL source;
    private final Document document;
    private final String renderedDocument;
    private final Configuration configuration;
    private final Map<String, ClassLoader> cacheClassLoaders;
    private final Map<String, Template> templates;
    private static final List<PrettyClassFormat> PRETTY_FORMATS = Arrays.asList(PrettyClassFormat.when("boolean"::equals).then((n, l) -> Boolean.TYPE), PrettyClassFormat.when("byte"::equals).then((n, l) -> Byte.TYPE), PrettyClassFormat.when("short"::equals).then((n, l) -> Short.TYPE), PrettyClassFormat.when("int"::equals).then((n, l) -> Integer.TYPE), PrettyClassFormat.when("long"::equals).then((n, l) -> Long.TYPE), PrettyClassFormat.when("char"::equals).then((n, l) -> Character.TYPE), PrettyClassFormat.when("float"::equals).then((n, l) -> Float.TYPE), PrettyClassFormat.when("double"::equals).then((n, l) -> Double.TYPE), PrettyClassFormat.when(n -> n.endsWith("[]")).then((n, l) -> {
        String component = n.split("(\\[\\])+$", 2)[0];
        int dimensions = n.length() - component.length() >> 1;
        return Array.newInstance(XmlConfiguration.getClassForName(component, l), new int[dimensions]).getClass();
    }), PrettyClassFormat.when(n -> n.contains(".")).then((n, l) -> {
        try {
            return Class.forName(n, false, l);
        }
        catch (ClassNotFoundException e) {
            int innerSeparator = n.lastIndexOf(".");
            if (innerSeparator == -1) {
                throw e;
            }
            return Class.forName(n.substring(0, innerSeparator) + "$" + n.substring(innerSeparator + 1), false, l);
        }
    }), PrettyClassFormat.when(n -> true).then((n, l) -> Class.forName(n, false, l)));

    public XmlConfiguration(URL url) throws XmlConfigurationException {
        this(url, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws XmlConfigurationException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws XmlConfigurationException {
        this.source = Objects.requireNonNull(url, "The url can not be null");
        Objects.requireNonNull(classLoader, "The classLoader can not be null");
        this.cacheClassLoaders = Objects.requireNonNull(cacheClassLoaders, "The cacheClassLoaders map can not be null");
        try {
            ConfigurationParser parser = new ConfigurationParser();
            this.document = parser.uriToDocument(this.source.toURI());
            ConfigurationParser.XmlConfigurationWrapper configWrapper = parser.documentToConfig(this.document, classLoader, cacheClassLoaders);
            this.configuration = configWrapper.getConfiguration();
            this.templates = configWrapper.getTemplates();
            this.renderedDocument = ConfigurationParser.urlToText(url, this.document.getInputEncoding());
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error parsing XML configuration at " + url, e);
        }
    }

    public XmlConfiguration(Document xml) throws XmlConfigurationException {
        this(xml, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(Document xml, ClassLoader classLoader) throws XmlConfigurationException {
        this(xml, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(Document xml, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws XmlConfigurationException {
        Objects.requireNonNull(xml, "The source-element cannot be null");
        Objects.requireNonNull(classLoader, "The classLoader can not be null");
        this.cacheClassLoaders = Objects.requireNonNull(cacheClassLoaders, "The cacheClassLoaders map can not be null");
        this.source = null;
        try {
            ConfigurationParser parser = new ConfigurationParser();
            this.document = xml;
            ConfigurationParser.XmlConfigurationWrapper configWrapper = parser.documentToConfig(this.document, classLoader, cacheClassLoaders);
            this.configuration = configWrapper.getConfiguration();
            this.templates = configWrapper.getTemplates();
            this.renderedDocument = ConfigurationParser.documentToText(xml);
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error parsing XML configuration", e);
        }
    }

    public XmlConfiguration(Configuration configuration) throws XmlConfigurationException {
        this.source = null;
        this.cacheClassLoaders = Collections.emptyMap();
        try {
            ConfigurationParser parser = new ConfigurationParser();
            this.configuration = configuration;
            this.templates = Collections.emptyMap();
            this.document = parser.configToDocument(configuration);
            this.renderedDocument = ConfigurationParser.documentToText(this.document);
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error unparsing configuration: " + configuration, e);
        }
    }

    public Document asDocument() {
        return this.document;
    }

    public String asRenderedDocument() {
        return this.renderedDocument;
    }

    public String toString() {
        return this.asRenderedDocument();
    }

    public URL getURL() {
        return this.source;
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Template template = this.templates.get(name);
        if (template == null) {
            return null;
        }
        return template.builderFor(this.cacheClassLoaders.getOrDefault(name, this.getClassLoader()), keyType, valueType, null);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Template template = this.templates.get(name);
        if (template == null) {
            return null;
        }
        return template.builderFor(this.cacheClassLoaders.getOrDefault(name, this.getClassLoader()), keyType, valueType, Objects.requireNonNull(resourcePools));
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.newCacheConfigurationBuilderFromTemplate(name, keyType, valueType, (ResourcePools)resourcePoolsBuilder.build());
    }

    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.configuration.getCacheConfigurations();
    }

    public Collection<ServiceCreationConfiguration<?, ?>> getServiceCreationConfigurations() {
        return this.configuration.getServiceCreationConfigurations();
    }

    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }

    public FluentConfigurationBuilder<?> derive() {
        return ConfigurationBuilder.newConfigurationBuilder((Configuration)this);
    }

    public static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String klazz = name.trim();
        return PRETTY_FORMATS.stream().filter(p -> p.applies().test(klazz)).findFirst().map(PrettyClassFormat::lookup).orElseThrow(AssertionError::new).lookup(klazz, classLoader);
    }

    private static interface Lookup {
        public Class<?> lookup(String var1, ClassLoader var2) throws ClassNotFoundException;
    }

    static interface PrettyClassFormat {
        public static Builder when(final Predicate<String> predicate) {
            return lookup -> new PrettyClassFormat(){

                @Override
                public Predicate<String> applies() {
                    return predicate;
                }

                @Override
                public Lookup lookup() {
                    return lookup;
                }
            };
        }

        public Predicate<String> applies();

        public Lookup lookup();

        public static interface Builder {
            public PrettyClassFormat then(Lookup var1);
        }
    }

    public static interface Template {
        public <K, V> CacheConfigurationBuilder<K, V> builderFor(ClassLoader var1, Class<K> var2, Class<V> var3, ResourcePools var4) throws ClassNotFoundException, InstantiationException, IllegalAccessException;
    }
}

