/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class OrderByItem
extends AbstractExpression {
    private AbstractExpression expression;
    private String firstIdentifier;
    private boolean hasSpaceAfterExpression;
    private boolean hasSpaceAfterNulls;
    private boolean hasSpaceAfterOrdering;
    private String lastIdentifier;
    private NullOrdering nullOrdering;
    private String nullsIdentifier;
    private Ordering ordering;
    private String orderingIdentifier;

    public OrderByItem(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasSpaceAfterExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.ordering != Ordering.DEFAULT) {
            children.add(this.buildStringExpression(this.ordering.toString()));
        }
        if (this.hasSpaceAfterOrdering) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.nullsIdentifier != null) {
            children.add(this.buildStringExpression("NULLS"));
        }
        if (this.hasSpaceAfterNulls) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.firstIdentifier != null) {
            children.add(this.buildStringExpression("FIRST"));
        } else if (this.lastIdentifier != null) {
            children.add(this.buildStringExpression("LAST"));
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.expression != null && this.expression.isAncestor(expression)) {
            return this.getQueryBNF("internal_orderby_item");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualNullOrdering() {
        if (this.nullsIdentifier != null && this.firstIdentifier != null) {
            return this.nullsIdentifier + ' ' + this.firstIdentifier;
        }
        if (this.nullsIdentifier != null && this.lastIdentifier != null) {
            return this.nullsIdentifier + ' ' + this.lastIdentifier;
        }
        if (this.nullsIdentifier != null) {
            return this.nullsIdentifier;
        }
        if (this.firstIdentifier != null) {
            return this.firstIdentifier;
        }
        if (this.lastIdentifier != null) {
            return this.lastIdentifier;
        }
        return "";
    }

    public String getActualOrdering() {
        return this.orderingIdentifier != null ? this.orderingIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("orderby_item");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNulls() {
        return this.nullsIdentifier != null;
    }

    public boolean hasOrdering() {
        return this.ordering != Ordering.DEFAULT;
    }

    public boolean hasSpaceAfterExpression() {
        return this.hasSpaceAfterExpression;
    }

    public boolean hasSpaceAfterNulls() {
        return this.hasSpaceAfterNulls;
    }

    public boolean hasSpaceAfterOrdering() {
        return this.hasSpaceAfterOrdering;
    }

    public boolean isAscending() {
        return this.ordering == Ordering.ASC;
    }

    public boolean isDefault() {
        return this.ordering == Ordering.DEFAULT;
    }

    public boolean isDescending() {
        return this.ordering == Ordering.DESC;
    }

    public boolean isNullsFirst() {
        return this.nullOrdering == NullOrdering.NULLS_FIRST;
    }

    public boolean isNullsLast() {
        return this.nullOrdering == NullOrdering.NULLS_LAST;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("ASC") || word.equalsIgnoreCase("DESC") || word.equalsIgnoreCase("NULLS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.expression = this.parse(wordParser, "internal_orderby_item", tolerant);
        boolean bl = this.hasSpaceAfterExpression = wordParser.skipLeadingWhitespace() > 0;
        if (!wordParser.isTail()) {
            String word = wordParser.word();
            if (word.equalsIgnoreCase("ASC")) {
                this.ordering = Ordering.ASC;
                this.orderingIdentifier = wordParser.moveForward("ASC".length());
            } else if (word.equalsIgnoreCase("DESC")) {
                this.ordering = Ordering.DESC;
                this.orderingIdentifier = wordParser.moveForward("DESC".length());
            } else {
                this.ordering = Ordering.DEFAULT;
            }
        } else {
            this.ordering = Ordering.DEFAULT;
        }
        if (!wordParser.isTail()) {
            int count = wordParser.skipLeadingWhitespace();
            boolean bl2 = this.hasSpaceAfterOrdering = count > 0;
            if (wordParser.startsWithIdentifier("NULLS")) {
                this.nullsIdentifier = wordParser.moveForward("NULLS");
                boolean bl3 = this.hasSpaceAfterNulls = wordParser.skipLeadingWhitespace() > 0;
            }
            if (wordParser.startsWithIdentifier("FIRST")) {
                this.firstIdentifier = wordParser.moveForward("FIRST");
            } else if (wordParser.startsWithIdentifier("LAST")) {
                this.lastIdentifier = wordParser.moveForward("LAST");
            }
            this.nullOrdering = this.nullsIdentifier != null && this.firstIdentifier != null ? NullOrdering.NULLS_FIRST : (this.nullsIdentifier != null && this.lastIdentifier != null ? NullOrdering.NULLS_LAST : NullOrdering.DEFAULT);
        } else {
            this.nullOrdering = NullOrdering.DEFAULT;
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterExpression) {
            writer.append(' ');
        }
        if (this.ordering != Ordering.DEFAULT) {
            writer.append(actual ? this.orderingIdentifier : this.ordering.name());
        }
        if (this.hasSpaceAfterOrdering) {
            writer.append(' ');
        }
        if (this.nullsIdentifier != null) {
            writer.append(actual ? this.nullsIdentifier : "NULLS");
        }
        if (this.hasSpaceAfterNulls) {
            writer.append(' ');
        }
        if (this.firstIdentifier != null) {
            writer.append(actual ? this.firstIdentifier : "FIRST");
        } else if (this.lastIdentifier != null) {
            writer.append(actual ? this.lastIdentifier : "LAST");
        }
    }

    public static enum Ordering {
        ASC,
        DEFAULT,
        DESC;

    }

    public static enum NullOrdering {
        DEFAULT(""),
        NULLS_FIRST("NULLS FIRST"),
        NULLS_LAST("NULLS LAST");

        private String identifier;

        private NullOrdering(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

