/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.api;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionSynchronizationContainer;
import org.drools.persistence.api.Transformable;

public class TransactionManagerHelper {
    private static final String APP_UPDETEABLE_RESOURCE = "app-updateable-resource";
    private static final String CMD_UPDETEABLE_RESOURCE = "cmd-updateable-resource";

    public static void registerTransactionSyncInContainer(TransactionManager txm, OrderedTransactionSynchronization synchronization) {
        TransactionSynchronizationContainer container = (TransactionSynchronizationContainer)txm.getResource("org.drools.persistence.txsync.container");
        if (container == null) {
            container = new TransactionSynchronizationContainer();
            txm.registerTransactionSynchronization(container);
            txm.putResource("org.drools.persistence.txsync.container", container);
        }
        container.addTransactionSynchronization(synchronization);
    }

    public static void addToUpdatableSet(TransactionManager txm, Transformable transformable) {
        if (transformable == null) {
            return;
        }
        LinkedHashSet<Transformable> toBeUpdated = (LinkedHashSet<Transformable>)txm.getResource(APP_UPDETEABLE_RESOURCE);
        if (toBeUpdated == null) {
            toBeUpdated = new LinkedHashSet<Transformable>();
            txm.putResource(APP_UPDETEABLE_RESOURCE, toBeUpdated);
        }
        toBeUpdated.add(transformable);
    }

    public static void removeFromUpdatableSet(TransactionManager txm, Transformable transformable) {
        Set toBeUpdated = (Set)txm.getResource(APP_UPDETEABLE_RESOURCE);
        if (toBeUpdated == null) {
            return;
        }
        toBeUpdated.remove(transformable);
    }

    public static Set<Transformable> getUpdateableSet(TransactionManager txm) {
        Set toBeUpdated = (Set)txm.getResource(APP_UPDETEABLE_RESOURCE);
        if (toBeUpdated == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<Transformable>(toBeUpdated);
    }
}

