/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.util.concurrent.CopyOnWriteArrayList;

public class DynamicByteArray {
    static final int UNIT_LENGTH = 64;
    private final CopyOnWriteArrayList<byte[]> byteArrayData = new CopyOnWriteArrayList();
    final int MAX_LENGTH;

    public DynamicByteArray(int maxLength) {
        this.MAX_LENGTH = maxLength;
    }

    void set(int index, byte value) {
        if (index >= this.MAX_LENGTH) {
            throw new IllegalArgumentException(String.format("Index value exceeds the maximum allowed length value.MAX_LENGTH = %d,index = %d", this.MAX_LENGTH, index));
        }
        int arrayAreaIndex = index / 64;
        byte[] bytes = this.getBytesWithOutNull(arrayAreaIndex);
        bytes[index - arrayAreaIndex * 64] = value;
    }

    void increase(int index) {
        if (index >= this.MAX_LENGTH) {
            throw new IllegalArgumentException(String.format("Index value exceeds the maximum allowed length value.MAX_LENGTH = %d,index = %d", this.MAX_LENGTH, index));
        }
        int arrayAreaIndex = index / 64;
        byte[] bytes = this.getBytesWithOutNull(arrayAreaIndex);
        int n = index - arrayAreaIndex * 64;
        bytes[n] = (byte)(bytes[n] + 1);
        if (bytes[n] > 7) {
            throw new IllegalStateException(String.format("Cannot proceed with grouping because the grouping level at this index position has reached the maximum 7.index = %s", index));
        }
    }

    private byte[] getBytesWithOutNull(int arrayAreaIndex) {
        if (arrayAreaIndex >= this.byteArrayData.size()) {
            for (int i = this.byteArrayData.size() - 1; i < arrayAreaIndex; ++i) {
                this.byteArrayData.add(null);
            }
        }
        if (this.byteArrayData.get(arrayAreaIndex) == null) {
            this.byteArrayData.set(arrayAreaIndex, new byte[64]);
        }
        return this.byteArrayData.get(arrayAreaIndex);
    }

    byte get(int index) {
        int arrayAreaIndex = index / 64;
        if (arrayAreaIndex > this.byteArrayData.size() - 1) {
            return 0;
        }
        byte[] bytes = this.byteArrayData.get(arrayAreaIndex);
        if (bytes == null) {
            return 0;
        }
        return bytes[index - arrayAreaIndex * 64];
    }

    int getMaxNoZeroIndex() {
        for (int areaIndex = this.byteArrayData.size(); areaIndex > 0; --areaIndex) {
            byte[] bytes = this.byteArrayData.get(areaIndex - 1);
            if (bytes == null) continue;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] == 0) continue;
                return i + (areaIndex - 1) * 64;
            }
        }
        return -1;
    }

    public String toString() {
        return this.buildToString(" ");
    }

    public String buildToString(String fillNullString) {
        StringBuilder builder = new StringBuilder();
        for (byte[] bytes : this.byteArrayData) {
            if (bytes == null) {
                builder.append(this.repeatString(fillNullString + ',', 64));
                continue;
            }
            for (byte aByte : bytes) {
                builder.append(aByte).append(',');
            }
        }
        return builder.toString();
    }

    private String repeatString(String seed, int n) {
        int seedLen = seed.length();
        char[] srcArr = seed.toCharArray();
        char[] dstArr = new char[n * seedLen];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < seedLen; ++j) {
                dstArr[i * seedLen + j] = srcArr[j];
            }
        }
        return String.valueOf(dstArr);
    }
}

