/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.dhatim.fastexcel.CachedString;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Ref;
import org.dhatim.fastexcel.TimestampUtil;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

class Cell
implements Ref {
    private Object value;
    private int style;

    Cell() {
    }

    void write(Writer w, int r, int c) throws IOException {
        if (this.value != null || this.style != 0) {
            w.append("<c r=\"").append(this.colToString(c)).append(r + 1).append('\"');
            if (this.style != 0) {
                w.append(" s=\"").append(this.style).append('\"');
            }
            if (this.value != null && !(this.value instanceof Formula)) {
                w.append(" t=\"").append(Cell.getCellType(this.value)).append('\"');
            }
            w.append(">");
            if (this.value instanceof Formula) {
                w.append("<f>").append(((Formula)this.value).getExpression()).append("</f>");
            } else if (this.value instanceof String) {
                w.append("<is><t>").appendEscaped((String)this.value).append("</t></is>");
            } else if (this.value != null) {
                w.append("<v>");
                if (this.value instanceof CachedString) {
                    w.append(((CachedString)this.value).getIndex());
                } else if (this.value instanceof Integer) {
                    w.append((Integer)this.value);
                } else if (this.value instanceof Long) {
                    w.append((Long)this.value);
                } else if (this.value instanceof Double) {
                    w.append((Double)this.value);
                } else if (this.value instanceof Boolean) {
                    w.append((Boolean)this.value != false ? (char)'1' : '0');
                } else {
                    w.append(this.value.toString());
                }
                w.append("</v>");
            }
            w.append("</c>");
        }
    }

    static String getCellType(Object value) {
        if (value instanceof CachedString) {
            return "s";
        }
        if (value instanceof Boolean) {
            return "b";
        }
        if (value instanceof String) {
            return "inlineStr";
        }
        return "n";
    }

    void setValue(Workbook wb, String v) {
        this.value = v == null ? null : wb.cacheString(v);
    }

    void setValue(Number v) {
        this.value = v;
    }

    void setValue(Boolean v) {
        this.value = v;
    }

    void setValue(Date v) {
        this.value = v == null ? null : TimestampUtil.convertDate(v);
    }

    void setValue(LocalDateTime v) {
        this.value = v == null ? null : TimestampUtil.convertDate(v);
    }

    void setValue(LocalDate v) {
        this.value = v == null ? null : TimestampUtil.convertDate(v);
    }

    void setValue(ZonedDateTime v) {
        this.value = v == null ? null : TimestampUtil.convertZonedDateTime(v);
    }

    Object getValue() {
        Object result = this.value instanceof CachedString ? ((CachedString)this.value).getString() : this.value;
        return result;
    }

    void setFormula(String expression) {
        this.value = new Formula(expression);
    }

    void setInlineString(String v) {
        this.value = v;
    }

    int getStyle() {
        return this.style;
    }

    void setStyle(int style) {
        this.style = style;
    }
}

