/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.transferlearning;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitDistribution;
import org.deeplearning4j.util.NetworkUtils;
import org.nd4j.common.primitives.Optional;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.regularization.L1Regularization;
import org.nd4j.linalg.learning.regularization.L2Regularization;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.learning.regularization.WeightDecay;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FineTuneConfiguration {
    protected IActivation activationFn;
    protected IWeightInit weightInitFn;
    protected Double biasInit;
    protected List<Regularization> regularization;
    protected List<Regularization> regularizationBias;
    protected boolean removeL2 = false;
    protected boolean removeL2Bias = false;
    protected boolean removeL1 = false;
    protected boolean removeL1Bias = false;
    protected boolean removeWD = false;
    protected boolean removeWDBias = false;
    protected Optional<IDropout> dropout;
    protected Optional<IWeightNoise> weightNoise;
    protected IUpdater updater;
    protected IUpdater biasUpdater;
    protected Boolean miniBatch;
    protected Integer maxNumLineSearchIterations;
    protected Long seed;
    protected OptimizationAlgorithm optimizationAlgo;
    protected StepFunction stepFunction;
    protected Boolean minimize;
    protected Optional<GradientNormalization> gradientNormalization;
    protected Double gradientNormalizationThreshold;
    protected ConvolutionMode convolutionMode;
    protected ConvolutionLayer.AlgoMode cudnnAlgoMode;
    protected Optional<List<LayerConstraint>> constraints;
    protected Boolean pretrain;
    protected Boolean backprop;
    protected BackpropType backpropType;
    protected Integer tbpttFwdLength;
    protected Integer tbpttBackLength;
    protected WorkspaceMode trainingWorkspaceMode;
    protected WorkspaceMode inferenceWorkspaceMode;

    public static Builder builder() {
        return new Builder();
    }

    public NeuralNetConfiguration appliedNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        this.applyToNeuralNetConfiguration(nnc);
        nnc = new NeuralNetConfiguration.Builder(nnc.clone()).build();
        return nnc;
    }

    public void applyToNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        Layer l = nnc.getLayer();
        Object originalUpdater = null;
        Object origWeightInit = null;
        if (l != null) {
            if (this.dropout != null && l instanceof BaseLayer) {
                IDropout d = (IDropout)this.dropout.orElse(null);
                if (d != null) {
                    d = d.clone();
                }
                l.setIDropout(d);
            }
            if (this.constraints != null) {
                l.setConstraints((List)this.constraints.orElse(null));
            }
        }
        if (l != null && l instanceof BaseLayer) {
            BaseLayer bl = (BaseLayer)l;
            if (this.activationFn != null) {
                bl.setActivationFn(this.activationFn);
            }
            if (this.weightInitFn != null) {
                bl.setWeightInitFn(this.weightInitFn);
            }
            if (this.biasInit != null) {
                bl.setBiasInit(this.biasInit);
            }
            if (this.regularization != null && !this.regularization.isEmpty()) {
                bl.setRegularization(this.regularization);
            }
            if (this.regularizationBias != null && !this.regularizationBias.isEmpty()) {
                bl.setRegularizationBias(this.regularizationBias);
            }
            if (this.removeL2) {
                NetworkUtils.removeInstances(bl.getRegularization(), L2Regularization.class);
            }
            if (this.removeL2Bias) {
                NetworkUtils.removeInstances(bl.getRegularizationBias(), L2Regularization.class);
            }
            if (this.removeL1) {
                NetworkUtils.removeInstances(bl.getRegularization(), L1Regularization.class);
            }
            if (this.removeL1Bias) {
                NetworkUtils.removeInstances(bl.getRegularizationBias(), L1Regularization.class);
            }
            if (this.removeWD) {
                NetworkUtils.removeInstances(bl.getRegularization(), WeightDecay.class);
            }
            if (this.removeWDBias) {
                NetworkUtils.removeInstances(bl.getRegularizationBias(), WeightDecay.class);
            }
            if (this.gradientNormalization != null) {
                bl.setGradientNormalization((GradientNormalization)((Object)this.gradientNormalization.orElse(null)));
            }
            if (this.gradientNormalizationThreshold != null) {
                bl.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
            }
            if (this.updater != null) {
                bl.setIUpdater(this.updater);
            }
            if (this.biasUpdater != null) {
                bl.setBiasUpdater(this.biasUpdater);
            }
            if (this.weightNoise != null) {
                bl.setWeightNoise((IWeightNoise)this.weightNoise.orElse(null));
            }
        }
        if (this.miniBatch != null) {
            nnc.setMiniBatch(this.miniBatch);
        }
        if (this.maxNumLineSearchIterations != null) {
            nnc.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            nnc.setSeed(this.seed);
        }
        if (this.optimizationAlgo != null) {
            nnc.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            nnc.setStepFunction(this.stepFunction);
        }
        if (this.minimize != null) {
            nnc.setMinimize(this.minimize);
        }
        if (this.convolutionMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (this.cudnnAlgoMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setCudnnAlgoMode(this.cudnnAlgoMode);
        }
        if (this.convolutionMode != null && l instanceof SubsamplingLayer) {
            ((SubsamplingLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (l != null) {
            LayerValidation.generalValidation(l.getLayerName(), l, FineTuneConfiguration.get(this.dropout), this.regularization, this.regularizationBias, FineTuneConfiguration.get(this.constraints), null, null);
        }
    }

    private static <T> T get(Optional<T> optional) {
        if (optional == null) {
            return null;
        }
        return (T)optional.orElse(null);
    }

    public void applyToMultiLayerConfiguration(MultiLayerConfiguration conf) {
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public void applyToComputationGraphConfiguration(ComputationGraphConfiguration conf) {
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public NeuralNetConfiguration.Builder appliedNeuralNetConfigurationBuilder() {
        NeuralNetConfiguration.Builder confBuilder = new NeuralNetConfiguration.Builder();
        if (this.activationFn != null) {
            confBuilder.setActivationFn(this.activationFn);
        }
        if (this.weightInitFn != null) {
            confBuilder.setWeightInitFn(this.weightInitFn);
        }
        if (this.biasInit != null) {
            confBuilder.setBiasInit(this.biasInit);
        }
        if (this.regularization != null) {
            confBuilder.setRegularization(this.regularization);
        }
        if (this.regularizationBias != null) {
            confBuilder.setRegularizationBias(this.regularizationBias);
        }
        if (this.dropout != null) {
            confBuilder.setIdropOut((IDropout)this.dropout.orElse(null));
        }
        if (this.updater != null) {
            confBuilder.updater(this.updater);
        }
        if (this.biasUpdater != null) {
            confBuilder.biasUpdater(this.biasUpdater);
        }
        if (this.miniBatch != null) {
            confBuilder.setMiniBatch(this.miniBatch);
        }
        if (this.maxNumLineSearchIterations != null) {
            confBuilder.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            confBuilder.setSeed(this.seed);
        }
        if (this.optimizationAlgo != null) {
            confBuilder.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            confBuilder.setStepFunction(this.stepFunction);
        }
        if (this.minimize != null) {
            confBuilder.setMinimize(this.minimize);
        }
        if (this.gradientNormalization != null) {
            confBuilder.setGradientNormalization((GradientNormalization)((Object)this.gradientNormalization.orElse(null)));
        }
        if (this.gradientNormalizationThreshold != null) {
            confBuilder.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
        }
        if (this.trainingWorkspaceMode != null) {
            confBuilder.trainingWorkspaceMode(this.trainingWorkspaceMode);
        }
        if (this.inferenceWorkspaceMode != null) {
            confBuilder.inferenceWorkspaceMode(this.inferenceWorkspaceMode);
        }
        return confBuilder;
    }

    public String toJson() {
        try {
            return NeuralNetConfiguration.mapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return NeuralNetConfiguration.mapperYaml().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromJson(String json) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapper().readValue(json, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FineTuneConfiguration fromYaml(String yaml) {
        try {
            return (FineTuneConfiguration)NeuralNetConfiguration.mapperYaml().readValue(yaml, FineTuneConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FineTuneConfiguration() {
    }

    public FineTuneConfiguration(IActivation activationFn, IWeightInit weightInitFn, Double biasInit, List<Regularization> regularization, List<Regularization> regularizationBias, boolean removeL2, boolean removeL2Bias, boolean removeL1, boolean removeL1Bias, boolean removeWD, boolean removeWDBias, Optional<IDropout> dropout, Optional<IWeightNoise> weightNoise, IUpdater updater, IUpdater biasUpdater, Boolean miniBatch, Integer maxNumLineSearchIterations, Long seed, OptimizationAlgorithm optimizationAlgo, StepFunction stepFunction, Boolean minimize, Optional<GradientNormalization> gradientNormalization, Double gradientNormalizationThreshold, ConvolutionMode convolutionMode, ConvolutionLayer.AlgoMode cudnnAlgoMode, Optional<List<LayerConstraint>> constraints, Boolean pretrain, Boolean backprop, BackpropType backpropType, Integer tbpttFwdLength, Integer tbpttBackLength, WorkspaceMode trainingWorkspaceMode, WorkspaceMode inferenceWorkspaceMode) {
        this.activationFn = activationFn;
        this.weightInitFn = weightInitFn;
        this.biasInit = biasInit;
        this.regularization = regularization;
        this.regularizationBias = regularizationBias;
        this.removeL2 = removeL2;
        this.removeL2Bias = removeL2Bias;
        this.removeL1 = removeL1;
        this.removeL1Bias = removeL1Bias;
        this.removeWD = removeWD;
        this.removeWDBias = removeWDBias;
        this.dropout = dropout;
        this.weightNoise = weightNoise;
        this.updater = updater;
        this.biasUpdater = biasUpdater;
        this.miniBatch = miniBatch;
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        this.seed = seed;
        this.optimizationAlgo = optimizationAlgo;
        this.stepFunction = stepFunction;
        this.minimize = minimize;
        this.gradientNormalization = gradientNormalization;
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        this.convolutionMode = convolutionMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
        this.constraints = constraints;
        this.pretrain = pretrain;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.trainingWorkspaceMode = trainingWorkspaceMode;
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public IWeightInit getWeightInitFn() {
        return this.weightInitFn;
    }

    public Double getBiasInit() {
        return this.biasInit;
    }

    public List<Regularization> getRegularization() {
        return this.regularization;
    }

    public List<Regularization> getRegularizationBias() {
        return this.regularizationBias;
    }

    public boolean isRemoveL2() {
        return this.removeL2;
    }

    public boolean isRemoveL2Bias() {
        return this.removeL2Bias;
    }

    public boolean isRemoveL1() {
        return this.removeL1;
    }

    public boolean isRemoveL1Bias() {
        return this.removeL1Bias;
    }

    public boolean isRemoveWD() {
        return this.removeWD;
    }

    public boolean isRemoveWDBias() {
        return this.removeWDBias;
    }

    public Optional<IDropout> getDropout() {
        return this.dropout;
    }

    public Optional<IWeightNoise> getWeightNoise() {
        return this.weightNoise;
    }

    public IUpdater getUpdater() {
        return this.updater;
    }

    public IUpdater getBiasUpdater() {
        return this.biasUpdater;
    }

    public Boolean getMiniBatch() {
        return this.miniBatch;
    }

    public Integer getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public Long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public Boolean getMinimize() {
        return this.minimize;
    }

    public Optional<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public Double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public ConvolutionLayer.AlgoMode getCudnnAlgoMode() {
        return this.cudnnAlgoMode;
    }

    public Optional<List<LayerConstraint>> getConstraints() {
        return this.constraints;
    }

    public Boolean getPretrain() {
        return this.pretrain;
    }

    public Boolean getBackprop() {
        return this.backprop;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public Integer getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public Integer getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public WorkspaceMode getTrainingWorkspaceMode() {
        return this.trainingWorkspaceMode;
    }

    public WorkspaceMode getInferenceWorkspaceMode() {
        return this.inferenceWorkspaceMode;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInitFn(IWeightInit weightInitFn) {
        this.weightInitFn = weightInitFn;
    }

    public void setBiasInit(Double biasInit) {
        this.biasInit = biasInit;
    }

    public void setRegularization(List<Regularization> regularization) {
        this.regularization = regularization;
    }

    public void setRegularizationBias(List<Regularization> regularizationBias) {
        this.regularizationBias = regularizationBias;
    }

    public void setRemoveL2(boolean removeL2) {
        this.removeL2 = removeL2;
    }

    public void setRemoveL2Bias(boolean removeL2Bias) {
        this.removeL2Bias = removeL2Bias;
    }

    public void setRemoveL1(boolean removeL1) {
        this.removeL1 = removeL1;
    }

    public void setRemoveL1Bias(boolean removeL1Bias) {
        this.removeL1Bias = removeL1Bias;
    }

    public void setRemoveWD(boolean removeWD) {
        this.removeWD = removeWD;
    }

    public void setRemoveWDBias(boolean removeWDBias) {
        this.removeWDBias = removeWDBias;
    }

    public void setDropout(Optional<IDropout> dropout) {
        this.dropout = dropout;
    }

    public void setWeightNoise(Optional<IWeightNoise> weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setUpdater(IUpdater updater) {
        this.updater = updater;
    }

    public void setBiasUpdater(IUpdater biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setMiniBatch(Boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setMaxNumLineSearchIterations(Integer maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setMinimize(Boolean minimize) {
        this.minimize = minimize;
    }

    public void setGradientNormalization(Optional<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(Double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setCudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public void setConstraints(Optional<List<LayerConstraint>> constraints) {
        this.constraints = constraints;
    }

    public void setPretrain(Boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setBackprop(Boolean backprop) {
        this.backprop = backprop;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(Integer tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(Integer tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
        this.trainingWorkspaceMode = trainingWorkspaceMode;
    }

    public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FineTuneConfiguration)) {
            return false;
        }
        FineTuneConfiguration other = (FineTuneConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoveL2() != other.isRemoveL2()) {
            return false;
        }
        if (this.isRemoveL2Bias() != other.isRemoveL2Bias()) {
            return false;
        }
        if (this.isRemoveL1() != other.isRemoveL1()) {
            return false;
        }
        if (this.isRemoveL1Bias() != other.isRemoveL1Bias()) {
            return false;
        }
        if (this.isRemoveWD() != other.isRemoveWD()) {
            return false;
        }
        if (this.isRemoveWDBias() != other.isRemoveWDBias()) {
            return false;
        }
        Double this$biasInit = this.getBiasInit();
        Double other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !((Object)this$biasInit).equals(other$biasInit)) {
            return false;
        }
        Boolean this$miniBatch = this.getMiniBatch();
        Boolean other$miniBatch = other.getMiniBatch();
        if (this$miniBatch == null ? other$miniBatch != null : !((Object)this$miniBatch).equals(other$miniBatch)) {
            return false;
        }
        Integer this$maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        Integer other$maxNumLineSearchIterations = other.getMaxNumLineSearchIterations();
        if (this$maxNumLineSearchIterations == null ? other$maxNumLineSearchIterations != null : !((Object)this$maxNumLineSearchIterations).equals(other$maxNumLineSearchIterations)) {
            return false;
        }
        Long this$seed = this.getSeed();
        Long other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$minimize = this.getMinimize();
        Boolean other$minimize = other.getMinimize();
        if (this$minimize == null ? other$minimize != null : !((Object)this$minimize).equals(other$minimize)) {
            return false;
        }
        Double this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        Double other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !((Object)this$gradientNormalizationThreshold).equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        Boolean this$pretrain = this.getPretrain();
        Boolean other$pretrain = other.getPretrain();
        if (this$pretrain == null ? other$pretrain != null : !((Object)this$pretrain).equals(other$pretrain)) {
            return false;
        }
        Boolean this$backprop = this.getBackprop();
        Boolean other$backprop = other.getBackprop();
        if (this$backprop == null ? other$backprop != null : !((Object)this$backprop).equals(other$backprop)) {
            return false;
        }
        Integer this$tbpttFwdLength = this.getTbpttFwdLength();
        Integer other$tbpttFwdLength = other.getTbpttFwdLength();
        if (this$tbpttFwdLength == null ? other$tbpttFwdLength != null : !((Object)this$tbpttFwdLength).equals(other$tbpttFwdLength)) {
            return false;
        }
        Integer this$tbpttBackLength = this.getTbpttBackLength();
        Integer other$tbpttBackLength = other.getTbpttBackLength();
        if (this$tbpttBackLength == null ? other$tbpttBackLength != null : !((Object)this$tbpttBackLength).equals(other$tbpttBackLength)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        IWeightInit this$weightInitFn = this.getWeightInitFn();
        IWeightInit other$weightInitFn = other.getWeightInitFn();
        if (this$weightInitFn == null ? other$weightInitFn != null : !this$weightInitFn.equals(other$weightInitFn)) {
            return false;
        }
        List<Regularization> this$regularization = this.getRegularization();
        List<Regularization> other$regularization = other.getRegularization();
        if (this$regularization == null ? other$regularization != null : !((Object)this$regularization).equals(other$regularization)) {
            return false;
        }
        List<Regularization> this$regularizationBias = this.getRegularizationBias();
        List<Regularization> other$regularizationBias = other.getRegularizationBias();
        if (this$regularizationBias == null ? other$regularizationBias != null : !((Object)this$regularizationBias).equals(other$regularizationBias)) {
            return false;
        }
        Optional<IDropout> this$dropout = this.getDropout();
        Optional<IDropout> other$dropout = other.getDropout();
        if (this$dropout == null ? other$dropout != null : !this$dropout.equals(other$dropout)) {
            return false;
        }
        Optional<IWeightNoise> this$weightNoise = this.getWeightNoise();
        Optional<IWeightNoise> other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        IUpdater this$updater = this.getUpdater();
        IUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        IUpdater this$biasUpdater = this.getBiasUpdater();
        IUpdater other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        Optional<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        Optional<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        ConvolutionLayer.AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
        ConvolutionLayer.AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
        if (this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode)) {
            return false;
        }
        Optional<List<LayerConstraint>> this$constraints = this.getConstraints();
        Optional<List<LayerConstraint>> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !this$constraints.equals(other$constraints)) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
        if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
            return false;
        }
        WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
        return !(this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FineTuneConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoveL2() ? 79 : 97);
        result = result * 59 + (this.isRemoveL2Bias() ? 79 : 97);
        result = result * 59 + (this.isRemoveL1() ? 79 : 97);
        result = result * 59 + (this.isRemoveL1Bias() ? 79 : 97);
        result = result * 59 + (this.isRemoveWD() ? 79 : 97);
        result = result * 59 + (this.isRemoveWDBias() ? 79 : 97);
        Double $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : ((Object)$biasInit).hashCode());
        Boolean $miniBatch = this.getMiniBatch();
        result = result * 59 + ($miniBatch == null ? 43 : ((Object)$miniBatch).hashCode());
        Integer $maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        result = result * 59 + ($maxNumLineSearchIterations == null ? 43 : ((Object)$maxNumLineSearchIterations).hashCode());
        Long $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $minimize = this.getMinimize();
        result = result * 59 + ($minimize == null ? 43 : ((Object)$minimize).hashCode());
        Double $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : ((Object)$gradientNormalizationThreshold).hashCode());
        Boolean $pretrain = this.getPretrain();
        result = result * 59 + ($pretrain == null ? 43 : ((Object)$pretrain).hashCode());
        Boolean $backprop = this.getBackprop();
        result = result * 59 + ($backprop == null ? 43 : ((Object)$backprop).hashCode());
        Integer $tbpttFwdLength = this.getTbpttFwdLength();
        result = result * 59 + ($tbpttFwdLength == null ? 43 : ((Object)$tbpttFwdLength).hashCode());
        Integer $tbpttBackLength = this.getTbpttBackLength();
        result = result * 59 + ($tbpttBackLength == null ? 43 : ((Object)$tbpttBackLength).hashCode());
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        IWeightInit $weightInitFn = this.getWeightInitFn();
        result = result * 59 + ($weightInitFn == null ? 43 : $weightInitFn.hashCode());
        List<Regularization> $regularization = this.getRegularization();
        result = result * 59 + ($regularization == null ? 43 : ((Object)$regularization).hashCode());
        List<Regularization> $regularizationBias = this.getRegularizationBias();
        result = result * 59 + ($regularizationBias == null ? 43 : ((Object)$regularizationBias).hashCode());
        Optional<IDropout> $dropout = this.getDropout();
        result = result * 59 + ($dropout == null ? 43 : $dropout.hashCode());
        Optional<IWeightNoise> $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        IUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        IUpdater $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        Optional<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        ConvolutionLayer.AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
        result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
        Optional<List<LayerConstraint>> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : $constraints.hashCode());
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
        WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
        WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
        return result;
    }

    public String toString() {
        return "FineTuneConfiguration(activationFn=" + this.getActivationFn() + ", weightInitFn=" + this.getWeightInitFn() + ", biasInit=" + this.getBiasInit() + ", regularization=" + this.getRegularization() + ", regularizationBias=" + this.getRegularizationBias() + ", removeL2=" + this.isRemoveL2() + ", removeL2Bias=" + this.isRemoveL2Bias() + ", removeL1=" + this.isRemoveL1() + ", removeL1Bias=" + this.isRemoveL1Bias() + ", removeWD=" + this.isRemoveWD() + ", removeWDBias=" + this.isRemoveWDBias() + ", dropout=" + this.getDropout() + ", weightNoise=" + this.getWeightNoise() + ", updater=" + this.getUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", miniBatch=" + this.getMiniBatch() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + this.getOptimizationAlgo() + ", stepFunction=" + this.getStepFunction() + ", minimize=" + this.getMinimize() + ", gradientNormalization=" + this.getGradientNormalization() + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", convolutionMode=" + this.getConvolutionMode() + ", cudnnAlgoMode=" + this.getCudnnAlgoMode() + ", constraints=" + this.getConstraints() + ", pretrain=" + this.getPretrain() + ", backprop=" + this.getBackprop() + ", backpropType=" + this.getBackpropType() + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", trainingWorkspaceMode=" + this.getTrainingWorkspaceMode() + ", inferenceWorkspaceMode=" + this.getInferenceWorkspaceMode() + ")";
    }

    public static class Builder {
        private IActivation activation;
        private IWeightInit weightInitFn;
        private Double biasInit;
        protected List<Regularization> regularization = new ArrayList<Regularization>();
        protected List<Regularization> regularizationBias = new ArrayList<Regularization>();
        protected boolean removeL2 = false;
        protected boolean removeL2Bias = false;
        protected boolean removeL1 = false;
        protected boolean removeL1Bias = false;
        protected boolean removeWD = false;
        protected boolean removeWDBias = false;
        private Optional<IDropout> dropout;
        private Optional<IWeightNoise> weightNoise;
        private IUpdater updater;
        private IUpdater biasUpdater;
        private Boolean miniBatch;
        private Integer maxNumLineSearchIterations;
        private Long seed;
        private OptimizationAlgorithm optimizationAlgo;
        private StepFunction stepFunction;
        private Boolean minimize;
        private Optional<GradientNormalization> gradientNormalization;
        private Double gradientNormalizationThreshold;
        private ConvolutionMode convolutionMode;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;
        private Optional<List<LayerConstraint>> constraints;
        private Boolean pretrain;
        private Boolean backprop;
        private BackpropType backpropType;
        private Integer tbpttFwdLength;
        private Integer tbpttBackLength;
        private WorkspaceMode trainingWorkspaceMode;
        private WorkspaceMode inferenceWorkspaceMode;

        public Builder activation(IActivation activationFn) {
            this.activation = activationFn;
            return this;
        }

        public Builder activation(Activation activation) {
            this.activation = activation.getActivationFunction();
            return this;
        }

        public Builder weightInit(IWeightInit weightInit) {
            this.weightInitFn = weightInit;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            if (weightInit == WeightInit.DISTRIBUTION) {
                throw new UnsupportedOperationException("Not supported!, User weightInit(Distribution distribution) instead!");
            }
            this.weightInitFn = weightInit.getWeightInitFunction();
            return this;
        }

        public Builder weightInit(Distribution distribution) {
            return this.weightInit(new WeightInitDistribution(distribution));
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        @Deprecated
        public Builder dist(Distribution dist) {
            return this.weightInit(dist);
        }

        public Builder l1(double l1) {
            NetworkUtils.removeInstances(this.regularization, L1Regularization.class);
            if (l1 > 0.0) {
                this.regularization.add((Regularization)new L1Regularization(l1));
            }
            return this;
        }

        public Builder l2(double l2) {
            NetworkUtils.removeInstances(this.regularization, L2Regularization.class);
            if (l2 > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, WeightDecay.class, "WeightDecay regularization removed: incompatible with added L2 regularization");
                this.regularization.add((Regularization)new L2Regularization(l2));
            } else {
                this.removeL2 = true;
            }
            return this;
        }

        public Builder l1Bias(double l1Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L1Regularization.class);
            if (l1Bias > 0.0) {
                this.regularizationBias.add((Regularization)new L1Regularization(l1Bias));
            } else {
                this.removeL1Bias = true;
            }
            return this;
        }

        public Builder l2Bias(double l2Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L2Regularization.class);
            if (l2Bias > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, WeightDecay.class, "WeightDecay bias regularization removed: incompatible with added L2 regularization");
                this.regularizationBias.add((Regularization)new L2Regularization(l2Bias));
            } else {
                this.removeL2Bias = true;
            }
            return this;
        }

        public Builder weightDecay(double coefficient) {
            return this.weightDecay(coefficient, true);
        }

        public Builder weightDecay(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularization, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, L2Regularization.class, "L2 regularization removed: incompatible with added WeightDecay regularization");
                this.regularization.add((Regularization)new WeightDecay(coefficient, applyLR));
            } else {
                this.removeWD = true;
            }
            return this;
        }

        public Builder weightDecayBias(double coefficient) {
            return this.weightDecayBias(coefficient, true);
        }

        public Builder weightDecayBias(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularizationBias, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, L2Regularization.class, "L2 bias regularization removed: incompatible with added WeightDecay regularization");
                this.regularizationBias.add((Regularization)new WeightDecay(coefficient, applyLR));
            } else {
                this.removeWDBias = true;
            }
            return this;
        }

        public Builder dropout(IDropout dropout) {
            this.dropout = Optional.ofNullable((Object)dropout);
            return this;
        }

        public Builder dropOut(double inputRetainProbability) {
            if (inputRetainProbability == 0.0) {
                return this.dropout(null);
            }
            return this.dropout(new Dropout(inputRetainProbability));
        }

        public Builder weightNoise(IWeightNoise weightNoise) {
            this.weightNoise = Optional.ofNullable((Object)weightNoise);
            return this;
        }

        public Builder updater(IUpdater updater) {
            this.updater = updater;
            return this;
        }

        @Deprecated
        public Builder updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public Builder biasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
            return this;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder seed(int seed) {
            return this.seed((long)seed);
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = Optional.ofNullable((Object)((Object)gradientNormalization));
            return this;
        }

        public Builder gradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            return this;
        }

        public Builder constraints(List<LayerConstraint> constraints) {
            this.constraints = Optional.ofNullable(constraints);
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public Builder backpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
            return this;
        }

        public Builder tbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return this;
        }

        public Builder tbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
            return this;
        }

        public Builder trainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
            this.trainingWorkspaceMode = trainingWorkspaceMode;
            return this;
        }

        public Builder inferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
            this.inferenceWorkspaceMode = inferenceWorkspaceMode;
            return this;
        }

        public FineTuneConfiguration build() {
            return new FineTuneConfiguration(this.activation, this.weightInitFn, this.biasInit, this.regularization, this.regularizationBias, this.removeL2, this.removeL2Bias, this.removeL1, this.removeL1Bias, this.removeWD, this.removeWDBias, this.dropout, this.weightNoise, this.updater, this.biasUpdater, this.miniBatch, this.maxNumLineSearchIterations, this.seed, this.optimizationAlgo, this.stepFunction, this.minimize, this.gradientNormalization, this.gradientNormalizationThreshold, this.convolutionMode, this.cudnnAlgoMode, this.constraints, this.pretrain, this.backprop, this.backpropType, this.tbpttFwdLength, this.tbpttBackLength, this.trainingWorkspaceMode, this.inferenceWorkspaceMode);
        }

        public String toString() {
            return "FineTuneConfiguration.Builder(activation=" + this.activation + ", weightInitFn=" + this.weightInitFn + ", biasInit=" + this.biasInit + ", regularization=" + this.regularization + ", regularizationBias=" + this.regularizationBias + ", removeL2=" + this.removeL2 + ", removeL2Bias=" + this.removeL2Bias + ", removeL1=" + this.removeL1 + ", removeL1Bias=" + this.removeL1Bias + ", removeWD=" + this.removeWD + ", removeWDBias=" + this.removeWDBias + ", dropout=" + this.dropout + ", weightNoise=" + this.weightNoise + ", updater=" + this.updater + ", biasUpdater=" + this.biasUpdater + ", miniBatch=" + this.miniBatch + ", maxNumLineSearchIterations=" + this.maxNumLineSearchIterations + ", seed=" + this.seed + ", optimizationAlgo=" + this.optimizationAlgo + ", stepFunction=" + this.stepFunction + ", minimize=" + this.minimize + ", gradientNormalization=" + this.gradientNormalization + ", gradientNormalizationThreshold=" + this.gradientNormalizationThreshold + ", convolutionMode=" + this.convolutionMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ", constraints=" + this.constraints + ", pretrain=" + this.pretrain + ", backprop=" + this.backprop + ", backpropType=" + this.backpropType + ", tbpttFwdLength=" + this.tbpttFwdLength + ", tbpttBackLength=" + this.tbpttBackLength + ", trainingWorkspaceMode=" + this.trainingWorkspaceMode + ", inferenceWorkspaceMode=" + this.inferenceWorkspaceMode + ")";
        }
    }
}

