/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseOutputLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;

public class RnnOutputLayer
extends BaseOutputLayer<org.deeplearning4j.nn.conf.layers.RnnOutputLayer> {
    public RnnOutputLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input is not rank 3. RnnOutputLayer expects rank 3 input with shape [minibatch, layerInSize, sequenceLength]. Got input with rank " + this.input.rank() + " and shape " + Arrays.toString(this.input.shape()) + " - " + this.layerId());
        }
        RNNFormat format = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat();
        int td = format == RNNFormat.NCW ? 2 : 1;
        Preconditions.checkState((this.labels.rank() == 3 ? 1 : 0) != 0, (String)"Expected rank 3 labels array, got label array with shape %ndShape", (Object)this.labels);
        Preconditions.checkState((this.input.size(td) == this.labels.size(td) ? 1 : 0) != 0, (String)"Sequence lengths do not match for RnnOutputLayer input and labels:Arrays should be rank 3 with shape [minibatch, size, sequenceLength] - mismatch on dimension 2 (sequence length) - input=%ndShape vs. label=%ndShape", (Object)this.input, (Object)this.labels);
        INDArray inputTemp = this.input;
        if (((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC) {
            this.input = this.input.permute(new int[]{0, 2, 1});
        }
        this.input = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.BP_WORKING_MEM);
        this.applyDropOutIfNecessary(true, workspaceMgr);
        Pair<Gradient, INDArray> gradAndEpsilonNext = super.backpropGradient(epsilon, workspaceMgr);
        this.input = inputTemp;
        INDArray epsilon2d = (INDArray)gradAndEpsilonNext.getSecond();
        INDArray epsilon3d = TimeSeriesUtils.reshape2dTo3d(epsilon2d, this.input.size(0), workspaceMgr, ArrayType.ACTIVATION_GRAD);
        if (((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC) {
            epsilon3d = epsilon3d.permute(new int[]{0, 2, 1});
        }
        this.weightNoiseParams.clear();
        return new Pair((Object)((Gradient)gradAndEpsilonNext.getFirst()), (Object)epsilon3d);
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        if (examples.rank() == 3) {
            examples = TimeSeriesUtils.reshape3dTo2d(examples, LayerWorkspaceMgr.noWorkspaces(), ArrayType.ACTIVATIONS);
        }
        if (labels.rank() == 3) {
            labels = TimeSeriesUtils.reshape3dTo2d(labels, LayerWorkspaceMgr.noWorkspaces(), ArrayType.ACTIVATIONS);
        }
        return super.f1Score(examples, labels);
    }

    @Override
    public INDArray getInput() {
        return this.input;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    protected INDArray preOutput2d(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.rank() == 3) {
            INDArray inputTemp = this.input;
            this.input = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC ? this.input.permute(new int[]{0, 2, 1}) : this.input;
            this.input = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
            INDArray out = super.preOutput(training, workspaceMgr);
            this.input = inputTemp;
            return out;
        }
        INDArray out = super.preOutput(training, workspaceMgr);
        return out;
    }

    @Override
    protected INDArray getLabels2d(LayerWorkspaceMgr workspaceMgr, ArrayType arrayType) {
        INDArray labels = this.labels;
        if (labels.rank() == 3) {
            labels = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC ? labels.permute(new int[]{0, 2, 1}) : labels;
            return TimeSeriesUtils.reshape3dTo2d(labels, workspaceMgr, arrayType);
        }
        return labels;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray input = this.input;
        if (input.rank() != 3) {
            throw new UnsupportedOperationException("Input must be rank 3. Got input with rank " + input.rank() + " " + this.layerId());
        }
        INDArray b = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray W = this.getParamWithNoise("W", training, workspaceMgr);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC) {
            input = input.permute(new int[]{0, 2, 1});
        }
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(input.castTo(W.dataType()), workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray act2d = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn().getActivation(input2d.mmul(W).addiRowVector(b), training);
        if (this.maskArray != null) {
            if (!this.maskArray.isColumnVectorOrScalar() || Arrays.equals(this.maskArray.shape(), act2d.shape())) {
                act2d.muli(this.maskArray.castTo(act2d.dataType()));
            } else {
                act2d.muliColumnVector(this.maskArray.castTo(act2d.dataType()));
            }
        }
        INDArray ret = TimeSeriesUtils.reshape2dTo3d(act2d, input.size(0), workspaceMgr, ArrayType.ACTIVATIONS);
        if (((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getRnnDataFormat() == RNNFormat.NWC) {
            ret = ret.permute(new int[]{0, 2, 1});
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMaskArray(INDArray maskArray) {
        if (maskArray != null) {
            if (maskArray.rank() == 2) {
                this.maskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
                return;
            } else {
                if (maskArray.rank() != 3) throw new UnsupportedOperationException("Invalid mask array: must be rank 2 or 3 (got: rank " + maskArray.rank() + ", shape = " + Arrays.toString(maskArray.shape()) + ") " + this.layerId());
                this.maskArray = TimeSeriesUtils.reshape3dTo2d(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
            }
            return;
        } else {
            this.maskArray = null;
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray != null && currentMaskState == MaskState.Active) {
            this.inputMaskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
            this.inputMaskArrayState = currentMaskState;
        } else {
            this.inputMaskArray = null;
            this.inputMaskArrayState = null;
        }
        return null;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetRegTerm, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray preOut = this.preOutput2d(false, workspaceMgr);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(workspaceMgr, ArrayType.FF_WORKING_MEM), preOut, ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn(), this.maskArray);
        INDArray scoreArrayTs = TimeSeriesUtils.reshapeVectorToTimeSeriesMask(scoreArray, (int)this.input.size(0));
        INDArray summedScores = scoreArrayTs.sum(true, new int[]{1});
        if (fullNetRegTerm != 0.0) {
            summedScores.addi((Number)fullNetRegTerm);
        }
        return summedScores;
    }
}

