/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToDepth
extends AbstractLayer<SpaceToDepthLayer> {
    private static final Logger log = LoggerFactory.getLogger(SpaceToDepth.class);

    public SpaceToDepth(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    private int getBlockSize() {
        return ((SpaceToDepthLayer)this.layerConf()).getBlockSize();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(true);
        INDArray input = this.input.castTo(epsilon.dataType());
        boolean nchw = ((SpaceToDepthLayer)this.layerConf()).getDataFormat() == CNN2DFormat.NCHW;
        long miniBatch = input.size(0);
        long inDepth = input.size(nchw ? 1 : 3);
        long inH = input.size(nchw ? 2 : 1);
        long inW = input.size(nchw ? 3 : 2);
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = inH;
            lArray = lArray2;
            lArray2[3] = inW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = inH;
            lArray3[2] = inW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] epsShape = lArray;
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, input.dataType(), epsShape, 'c');
        DefaultGradient gradient = new DefaultGradient();
        int blockSize = this.getBlockSize();
        if (!Shape.hasDefaultStridesForShape((INDArray)epsilon)) {
            epsilon = epsilon.dup('c');
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"depth_to_space").addInputs(new INDArray[]{epsilon}).addIntegerArguments(new int[]{blockSize, nchw ? 0 : 1}).addOutputs(new INDArray[]{outEpsilon}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)gradient, (Object)outEpsilon);
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to space to channels with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((SpaceToDepthLayer)this.layerConf()).getDataFormat().dimensionNames() + ". " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        boolean nchw = ((SpaceToDepthLayer)this.layerConf()).getDataFormat() == CNN2DFormat.NCHW;
        long miniBatch = this.input.size(0);
        long depth = this.input.size(nchw ? 1 : 3);
        long inH = this.input.size(nchw ? 2 : 1);
        long inW = this.input.size(nchw ? 3 : 2);
        int blockSize = this.getBlockSize();
        long outH = inH / (long)blockSize;
        long outW = inW / (long)blockSize;
        long outDepth = depth * (long)blockSize * (long)blockSize;
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = outDepth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = outDepth;
        }
        long[] outShape = lArray;
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        INDArray input = this.input;
        if (!Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = input.dup('c');
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"space_to_depth").addInputs(new INDArray[]{input}).addIntegerArguments(new int[]{blockSize, nchw ? 0 : 1}).addOutputs(new INDArray[]{out}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return out;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, false, workspaceMgr);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

