/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationQuery
extends Query<Violation> {
    public static final String BASE_URL = "/api/violations";
    private String resourceKeyOrId;
    private int depth = 0;
    private String[] scopes;
    private String[] qualifiers;
    private String[] ruleKeys;
    private String[] categories;
    private String[] severities;
    private Integer limit;
    private Boolean includeReview;
    private String output;

    public ViolationQuery(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public ViolationQuery setScopes(String ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    public ViolationQuery setQualifiers(String ... qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public String[] getRuleKeys() {
        return this.ruleKeys;
    }

    public ViolationQuery setRuleKeys(String ... ruleKeys) {
        this.ruleKeys = ruleKeys;
        return this;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public ViolationQuery setCategories(String ... categories) {
        this.categories = categories;
        return this;
    }

    public String[] getSeverities() {
        return this.severities;
    }

    public ViolationQuery setSeverities(String ... severities) {
        this.severities = severities;
        return this;
    }

    @Deprecated
    public String[] getPriorities() {
        return this.severities;
    }

    @Deprecated
    public ViolationQuery setPriorities(String ... priorities) {
        this.severities = priorities;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public ViolationQuery setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ViolationQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean getIncludeReview() {
        return this.includeReview;
    }

    public ViolationQuery setIncludeReview(Boolean includeReview) {
        this.includeReview = includeReview;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public ViolationQuery setOutput(String output) {
        this.output = output;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        ViolationQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        if (this.depth != 0) {
            url.append("depth=").append(this.depth).append("&");
        }
        ViolationQuery.appendUrlParameter(url, "limit", this.limit);
        ViolationQuery.appendUrlParameter(url, "scopes", this.scopes);
        ViolationQuery.appendUrlParameter(url, "qualifiers", this.qualifiers);
        ViolationQuery.appendUrlParameter(url, "rules", this.ruleKeys);
        ViolationQuery.appendUrlParameter(url, "categories", this.categories);
        ViolationQuery.appendUrlParameter(url, "priorities", this.severities);
        ViolationQuery.appendUrlParameter(url, "include_review", this.includeReview);
        ViolationQuery.appendUrlParameter(url, "output", this.output);
        return url.toString();
    }

    @Override
    public Class<Violation> getModelClass() {
        return Violation.class;
    }

    public static ViolationQuery createForResource(Resource resource) {
        return new ViolationQuery(resource.getId().toString());
    }

    public static ViolationQuery createForResource(String resourceIdOrKey) {
        return new ViolationQuery(resourceIdOrKey);
    }
}

