/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import jnlp.sample.servlet.XMLAttribute;

public class XMLNode {
    private boolean _isElement = true;
    private String _name;
    private XMLAttribute _attr;
    private XMLNode _parent;
    private XMLNode _nested;
    private XMLNode _next;

    public XMLNode(String name) {
        this(name, null, null, null);
        this._isElement = false;
    }

    public XMLNode(String name, XMLAttribute attr) {
        this(name, attr, null, null);
    }

    public XMLNode(String name, XMLAttribute attr, XMLNode nested, XMLNode next) {
        this._name = name;
        this._attr = attr;
        this._nested = nested;
        this._next = next;
        this._parent = null;
    }

    public String getName() {
        return this._name;
    }

    public XMLAttribute getAttributes() {
        return this._attr;
    }

    public XMLNode getNested() {
        return this._nested;
    }

    public XMLNode getNext() {
        return this._next;
    }

    public boolean isElement() {
        return this._isElement;
    }

    public void setParent(XMLNode parent) {
        this._parent = parent;
    }

    public XMLNode getParent() {
        return this._parent;
    }

    public void setNext(XMLNode next) {
        this._next = next;
    }

    public void setNested(XMLNode nested) {
        this._nested = nested;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XMLNode)) {
            return false;
        }
        XMLNode other = (XMLNode)o;
        boolean result = XMLNode.match(this._name, other._name) && XMLNode.match(this._attr, other._attr) && XMLNode.match(this._nested, other._nested) && XMLNode.match(this._next, other._next);
        return result;
    }

    public String getAttribute(String name) {
        for (XMLAttribute cur = this._attr; cur != null; cur = cur.getNext()) {
            if (!name.equals(cur.getName())) continue;
            return cur.getValue();
        }
        return "";
    }

    private static boolean match(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public void printToStream(PrintWriter out) {
        this.printToStream(out, 0);
    }

    public void printToStream(PrintWriter out, int n) {
        if (!this.isElement()) {
            out.print(this._name);
        } else if (this._nested == null) {
            String attrString = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(out, n, "<" + this._name + attrString + "/>");
        } else {
            String attrString = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(out, n, "<" + this._name + attrString + ">");
            this._nested.printToStream(out, n + 1);
            if (this._nested.isElement()) {
                XMLNode.lineln(out, n, "</" + this._name + ">");
            } else {
                out.print("</" + this._name + ">");
            }
        }
        if (this._next != null) {
            this._next.printToStream(out, n);
        }
    }

    private static void lineln(PrintWriter out, int indent, String s) {
        out.println("");
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
        out.print(s);
    }

    public String toString() {
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        this.printToStream(pw);
        pw.close();
        return sw.toString();
    }
}

