/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport.dependency;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.mojo.pluginsupport.dependency.DependencyResolutionListener;
import org.codehaus.mojo.pluginsupport.dependency.DependencyTree;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DependencyHelper
implements Contextualizable {
    private ArtifactRepositoryFactory artifactRepositoryFactory = null;
    private ArtifactMetadataSource artifactMetadataSource = null;
    private ArtifactCollector artifactCollector = null;
    private ArtifactFactory artifactFactory = null;
    private ArtifactResolver artifactResolver = null;
    private PlexusContainer container;
    private ArtifactRepository repository;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setArtifactRepository(ArtifactRepository repository) {
        this.repository = repository;
    }

    private ArtifactRepository getArtifactRepository() {
        if (this.repository == null) {
            throw new IllegalStateException("Not initialized; missing ArtifactRepository");
        }
        return this.repository;
    }

    public DependencyTree getDependencies(MavenProject project) throws ProjectBuildingException, InvalidDependencyVersionException, ArtifactResolutionException {
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        Map managedVersions = DependencyHelper.getManagedVersionMap(project, this.artifactFactory);
        DependencyResolutionListener listener = new DependencyResolutionListener();
        if (project.getDependencyArtifacts() == null) {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        this.artifactCollector.collect(project.getDependencyArtifacts(), project.getArtifact(), managedVersions, this.getArtifactRepository(), project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        return listener.getDependencyTree();
    }

    public static Map getManagedVersionMap(MavenProject project, ArtifactFactory factory) throws ProjectBuildingException {
        HashMap<String, Artifact> managedVersionMap;
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && factory == null) {
            throw new AssertionError();
        }
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            managedVersionMap = new HashMap<String, Artifact>();
            Iterator iter = dependencyManagement.getDependencies().iterator();
            while (iter.hasNext()) {
                Dependency d = (Dependency)iter.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    managedVersionMap.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(project.getId(), "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            managedVersionMap = Collections.EMPTY_MAP;
        }
        return managedVersionMap;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public ArtifactRepositoryFactory getArtifactRepositoryFactory() {
        return this.artifactRepositoryFactory;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    static {
        $assertionsDisabled = !DependencyHelper.class.desiredAssertionStatus();
    }
}

