/*
 * #%L
 * License Maven Plugin
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin, Codehaus, Tony Chemit, Tony chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.nio.file.Path;
import java.nio.file.Files;

final Path basePath = basedir.toPath()

final String baseUri = basePath.toUri().toString()
final Path sanitizesConfigPath = basePath.resolve('src/license/licenses-config-content-sanitizers.xml');
String sanitizersConfigContent = new String(Files.readAllBytes(sanitizesConfigPath), 'utf-8')
sanitizersConfigContent = sanitizersConfigContent.replace('%project.baseUri%', baseUri)
Files.write(sanitizesConfigPath, sanitizersConfigContent.getBytes('utf-8'))

Files.move(basePath.resolve('target-initial'), basePath.resolve('target'))

final Path asl2 = basePath.resolve('target/no-download/licenses/apache-license-2.0-license-2.0.txt')
assert Files.exists(asl2)
assert asl2.toFile().text.contains('Fake content')

final Path bsd = basePath.resolve('target/no-download/licenses/bsd-3-clause-asm-license.txt')
assert Files.exists(bsd)
assert bsd.toFile().text.contains('Fake content')
