/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import java.util.Map;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SortableLocation;

public class DefaultJavaDocRenderer
implements JavaDocRenderer {
    @Override
    public String render(JavaDocData nonNullData, SortableLocation location) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.renderJavaDocComment(nonNullData.getComment(), location)).append("\n");
        for (Map.Entry<String, String> current : nonNullData.getTag2ValueMap().entrySet()) {
            String tagXsdDoc = this.renderJavaDocTag(current.getKey(), current.getValue(), location);
            if (tagXsdDoc == null || tagXsdDoc.isEmpty()) continue;
            builder.append(tagXsdDoc);
        }
        return builder.toString();
    }

    protected String renderJavaDocComment(String comment, SortableLocation location) {
        return this.harmonizeNewlines(comment);
    }

    protected String renderJavaDocTag(String name, String value, SortableLocation location) {
        String nameKey = name != null ? name.trim() : "";
        String valueKey = value != null ? value.trim() : "";
        return "(" + nameKey + "): " + this.harmonizeNewlines(valueKey);
    }

    protected String harmonizeNewlines(String original) {
        String toReturn = original.trim().replaceAll("[\r\n]+", "\n");
        return toReturn.endsWith("\n") ? toReturn : toReturn + "\n";
    }
}

