/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.schemageneration.AbstractXsdGeneratorMojo;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.NodeProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.XsdAnnotationProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.XsdEnumerationAnnotationProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.ChangeFilenameProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.ChangeNamespacePrefixProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.SimpleNamespaceResolver;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.TransformSchema;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XsdGeneratorHelper {
    private static final String MISCONFIG = "Misconfiguration detected: ";
    private static TransformerFactory FACTORY;
    private static final FileFilter RECURSIVE_XSD_FILTER;

    private XsdGeneratorHelper() {
    }

    public static Map<String, SimpleNamespaceResolver> getFileNameToResolverMap(File outputDirectory) throws MojoExecutionException {
        File[] generatedSchemaFiles;
        TreeMap<String, SimpleNamespaceResolver> toReturn = new TreeMap<String, SimpleNamespaceResolver>();
        for (File current : generatedSchemaFiles = outputDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith("schema") && pathname.getName().endsWith(".xsd");
            }
        })) {
            toReturn.put(current.getName(), new SimpleNamespaceResolver(current));
        }
        return toReturn;
    }

    public static void validateSchemasInPluginConfiguration(List<TransformSchema> configuredTransformSchemas) throws MojoExecutionException {
        ArrayList<String> uris = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < configuredTransformSchemas.size(); ++i) {
            TransformSchema current = configuredTransformSchemas.get(i);
            String currentURI = current.getUri();
            String currentPrefix = current.getToPrefix();
            String currentFile = current.getToFile();
            if (StringUtils.isEmpty((String)currentURI)) {
                throw new MojoExecutionException("Misconfiguration detected: Null or empty property 'uri' found in plugin configuration for schema element at index [" + i + "]: " + current);
            }
            if (StringUtils.isEmpty((String)currentPrefix) && StringUtils.isEmpty((String)currentFile)) {
                throw new MojoExecutionException("Misconfiguration detected: Null or empty properties 'prefix' and 'file' found within plugin configuration for schema element at index [" + i + "]: " + current);
            }
            if (uris.contains(currentURI)) {
                throw new MojoExecutionException(XsdGeneratorHelper.getDuplicationErrorMessage("uri", currentURI, uris.indexOf(currentURI), i));
            }
            uris.add(currentURI);
            if (prefixes.contains(currentPrefix) && currentPrefix != null) {
                throw new MojoExecutionException(XsdGeneratorHelper.getDuplicationErrorMessage("prefix", currentPrefix, prefixes.indexOf(currentPrefix), i));
            }
            prefixes.add(currentPrefix);
            if (fileNames.contains(currentFile)) {
                throw new MojoExecutionException(XsdGeneratorHelper.getDuplicationErrorMessage("file", currentFile, fileNames.indexOf(currentFile), i));
            }
            fileNames.add(currentFile);
        }
    }

    public static int insertJavaDocAsAnnotations(Log log, String encoding, File outputDir, SearchableDocumentation docs, JavaDocRenderer renderer) {
        Validate.notNull(docs, "docs");
        Validate.notNull(log, "log");
        Validate.notNull(outputDir, "outputDir");
        Validate.isTrue(outputDir.isDirectory(), "'outputDir' must be a Directory.");
        Validate.notNull(renderer, "renderer");
        int processedXSDs = 0;
        ArrayList<File> foundFiles = new ArrayList<File>();
        XsdGeneratorHelper.addRecursively(foundFiles, RECURSIVE_XSD_FILTER, outputDir);
        if (foundFiles.size() > 0) {
            XsdAnnotationProcessor classProcessor = new XsdAnnotationProcessor(docs, renderer);
            XsdEnumerationAnnotationProcessor enumProcessor = new XsdEnumerationAnnotationProcessor(docs, renderer);
            for (File current : foundFiles) {
                Document generatedSchemaFileDocument = XsdGeneratorHelper.parseXmlToDocument(current, encoding);
                XsdGeneratorHelper.process(generatedSchemaFileDocument.getFirstChild(), true, classProcessor);
                ++processedXSDs;
                XsdGeneratorHelper.savePrettyPrintedDocument(generatedSchemaFileDocument, current, encoding);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((CharSequence)("Found no generated 'vanilla' XSD files to process under [" + FileSystemUtilities.getCanonicalPath(outputDir) + "]. Aborting processing."));
        }
        return processedXSDs;
    }

    public static void replaceNamespacePrefixes(Map<String, SimpleNamespaceResolver> resolverMap, List<TransformSchema> configuredTransformSchemas, Log mavenLog, File schemaDirectory, String encoding) throws MojoExecutionException {
        if (mavenLog.isDebugEnabled()) {
            mavenLog.debug((CharSequence)("Got resolverMap.keySet() [generated filenames]: " + resolverMap.keySet()));
        }
        for (SimpleNamespaceResolver currentResolver : resolverMap.values()) {
            File generatedSchemaFile = new File(schemaDirectory, currentResolver.getSourceFilename());
            Node generatedSchemaFileDocument = null;
            for (TransformSchema currentTransformSchema : configuredTransformSchemas) {
                String oldPrefix;
                String newPrefix = currentTransformSchema.getToPrefix();
                String currentUri = currentTransformSchema.getUri();
                if (!StringUtils.isNotEmpty((String)newPrefix) || !StringUtils.isNotEmpty((String)(oldPrefix = currentResolver.getNamespaceURI2PrefixMap().get(currentUri)))) continue;
                XsdGeneratorHelper.validatePrefixSubstitutionIsPossible(oldPrefix, newPrefix, currentResolver);
                if (mavenLog.isDebugEnabled()) {
                    mavenLog.debug((CharSequence)("Subtituting namespace prefix [" + oldPrefix + "] with [" + newPrefix + "] in file [" + currentResolver.getSourceFilename() + "]."));
                }
                if (generatedSchemaFileDocument == null) {
                    generatedSchemaFileDocument = XsdGeneratorHelper.parseXmlToDocument(generatedSchemaFile, encoding);
                }
                XsdGeneratorHelper.process(generatedSchemaFileDocument.getFirstChild(), true, new ChangeNamespacePrefixProcessor(oldPrefix, newPrefix));
            }
            if (generatedSchemaFileDocument != null) {
                mavenLog.debug((CharSequence)("Overwriting file [" + currentResolver.getSourceFilename() + "] with content [" + XsdGeneratorHelper.getHumanReadableXml(generatedSchemaFileDocument) + "]"));
                XsdGeneratorHelper.savePrettyPrintedDocument(generatedSchemaFileDocument, generatedSchemaFile, encoding);
                continue;
            }
            mavenLog.debug((CharSequence)("No namespace prefix changes to generated schema file [" + generatedSchemaFile.getName() + "]"));
        }
    }

    public static void renameGeneratedSchemaFiles(Map<String, SimpleNamespaceResolver> resolverMap, List<TransformSchema> configuredTransformSchemas, Log mavenLog, File schemaDirectory, String encoding) {
        TreeMap<String, String> namespaceUriToDesiredFilenameMap = new TreeMap<String, String>();
        for (TransformSchema current : configuredTransformSchemas) {
            if (!StringUtils.isNotEmpty((String)current.getToFile())) continue;
            namespaceUriToDesiredFilenameMap.put(current.getUri(), current.getToFile());
        }
        for (SimpleNamespaceResolver currentResolver : resolverMap.values()) {
            File generatedSchemaFile = new File(schemaDirectory, currentResolver.getSourceFilename());
            Document generatedSchemaFileDocument = XsdGeneratorHelper.parseXmlToDocument(generatedSchemaFile, encoding);
            XsdGeneratorHelper.process(generatedSchemaFileDocument.getFirstChild(), true, new ChangeFilenameProcessor(namespaceUriToDesiredFilenameMap));
            if (mavenLog.isDebugEnabled()) {
                mavenLog.debug((CharSequence)("Changed schemaLocation entries within [" + currentResolver.getSourceFilename() + "]. Result: [" + XsdGeneratorHelper.getHumanReadableXml(generatedSchemaFileDocument) + "]"));
            }
            XsdGeneratorHelper.savePrettyPrintedDocument(generatedSchemaFileDocument, generatedSchemaFile, encoding);
        }
        for (SimpleNamespaceResolver currentResolver : resolverMap.values()) {
            String renameResult;
            String localNamespaceURI = currentResolver.getLocalNamespaceURI();
            if (StringUtils.isEmpty((String)localNamespaceURI)) {
                mavenLog.warn((CharSequence)"SimpleNamespaceResolver contained no localNamespaceURI; aborting rename.");
                continue;
            }
            String newFilename = (String)namespaceUriToDesiredFilenameMap.get(localNamespaceURI);
            File originalFile = new File(schemaDirectory, currentResolver.getSourceFilename());
            if (!StringUtils.isNotEmpty((String)newFilename)) continue;
            File renamedFile = FileUtils.resolveFile((File)schemaDirectory, (String)newFilename);
            String string = renameResult = originalFile.renameTo(renamedFile) ? "Success " : "Failure ";
            if (!mavenLog.isDebugEnabled()) continue;
            String suffix = "renaming [" + originalFile.getAbsolutePath() + "] to [" + renamedFile + "]";
            mavenLog.debug((CharSequence)(renameResult + suffix));
        }
    }

    public static void process(Node node, boolean recurseToChildren, NodeProcessor visitor) {
        if (visitor.accept(node)) {
            visitor.process(node);
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!visitor.accept(attribute)) continue;
            visitor.process(attribute);
        }
        if (recurseToChildren) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                XsdGeneratorHelper.process(child, true, visitor);
            }
        }
    }

    public static Document parseXmlStream(Reader xmlStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(new InputSource(xmlStream));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not acquire DOM Document", e);
        }
    }

    protected static String getHumanReadableXml(Node node) {
        StringWriter toReturn = new StringWriter();
        try {
            Transformer transformer = XsdGeneratorHelper.getFactory().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(toReturn));
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Could not transform node [" + node.getNodeName() + "] to XML", e);
        }
        return toReturn.toString();
    }

    private static String getDuplicationErrorMessage(String propertyName, String propertyValue, int firstIndex, int currentIndex) {
        return "Misconfiguration detected: Duplicate '" + propertyName + "' property with value [" + propertyValue + "] found in plugin configuration. Correct schema elements index (" + firstIndex + ") and (" + currentIndex + "), to ensure that all '" + propertyName + "' values are unique.";
    }

    private static void validatePrefixSubstitutionIsPossible(String oldPrefix, String newPrefix, SimpleNamespaceResolver currentResolver) throws MojoExecutionException {
        if (currentResolver.getNamespaceURI2PrefixMap().containsValue(newPrefix)) {
            throw new MojoExecutionException("Misconfiguration detected: Namespace prefix [" + newPrefix + "] is already in use. Cannot replace namespace prefix [" + oldPrefix + "] with [" + newPrefix + "] in file [" + currentResolver.getSourceFilename() + "].");
        }
    }

    /*
     * Loose catch block
     */
    private static Document parseXmlToDocument(File xmlFile, String encoding) {
        Document result = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(xmlFile), encoding);
            result = XsdGeneratorHelper.parseXmlStream(reader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtil.close(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not read xml file using encoding [" + encoding + "]", e);
            {
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
        }
        IOUtil.close((Reader)reader);
        return result;
    }

    private static void savePrettyPrintedDocument(Document toSave, File targetFile, String charsetName) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), charsetName));
            out.write(XsdGeneratorHelper.getHumanReadableXml(toSave.getFirstChild()));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Could not write to file [" + targetFile.getAbsolutePath() + "]", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
    }

    private static void addRecursively(List<File> toPopulate, FileFilter fileFilter, File aDir) {
        Validate.notNull(toPopulate, "toPopulate");
        Validate.notNull(fileFilter, "fileFilter");
        Validate.notNull(aDir, "aDir");
        for (File current : aDir.listFiles(fileFilter)) {
            if (current.isFile()) {
                toPopulate.add(current);
                continue;
            }
            if (!current.isDirectory()) continue;
            XsdGeneratorHelper.addRecursively(toPopulate, fileFilter, current);
        }
    }

    private static TransformerFactory getFactory() {
        if (FACTORY == null) {
            try {
                FACTORY = TransformerFactory.newInstance();
                for (String currentAttributeName : Arrays.asList("indent-number", "indent")) {
                    try {
                        FACTORY.setAttribute(currentAttributeName, 2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (Throwable exception) {
                throw new IllegalStateException("Could not acquire TransformerFactory implementation.", exception);
            }
        }
        return FACTORY;
    }

    static {
        RECURSIVE_XSD_FILTER = new FileFilter(){

            @Override
            public boolean accept(File toMatch) {
                if (toMatch.exists()) {
                    return toMatch.isDirectory() || AbstractXsdGeneratorMojo.SCHEMAGEN_EMITTED_FILENAME.matcher(toMatch.getName()).matches();
                }
                return false;
            }
        };
    }
}

